/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.awslambda.AwsLambdaEvent;
import de.quantummaid.httpmaid.awslambda.AwsWebsocketAuthorizationException;
import de.quantummaid.httpmaid.awslambda.AwsWebsocketConnectionInformation;
import de.quantummaid.httpmaid.awslambda.AwsWebsocketSender;
import de.quantummaid.httpmaid.awslambda.MapDeserializer;
import de.quantummaid.httpmaid.awslambda.WebsocketEventUtils;
import de.quantummaid.httpmaid.awslambda.apigateway.ApiGatewayClientFactory;
import de.quantummaid.httpmaid.awslambda.apigateway.DefaultApiGatewayClientFactory;
import de.quantummaid.httpmaid.awslambda.authorizer.LambdaWebsocketAuthorizer;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.authorization.AuthorizationDecision;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketConnectBuilder;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketDisconnect;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketMessage;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSender;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public final class AwsWebsocketLambdaEndpoint {
    private static final String CONNECT_EVENT_TYPE = "CONNECT";
    private static final String DISCONNECT_EVENT_TYPE = "DISCONNECT";
    private static final String MESSAGE_EVENT_TYPE = "MESSAGE";
    private static final String REQUEST_CONTEXT_KEY = "requestContext";
    private static final String AUTHORIZER_KEY = "authorizer";
    private final HttpMaid httpMaid;
    private final String region;

    public static AwsWebsocketLambdaEndpoint awsWebsocketLambdaEndpointFor(HttpMaid httpMaid, String region) {
        return AwsWebsocketLambdaEndpoint.awsWebsocketLambdaEndpointFor(httpMaid, region, DefaultApiGatewayClientFactory.defaultApiGatewayClientFactory());
    }

    public static AwsWebsocketLambdaEndpoint awsWebsocketLambdaEndpointFor(HttpMaid httpMaid, String region, ApiGatewayClientFactory apiGatewayClientFactory) {
        Validators.validateNotNull((Object)httpMaid, (String)"httpMaid");
        Validators.validateNotNullNorEmpty((String)region, (String)"region");
        Validators.validateNotNull((Object)apiGatewayClientFactory, (String)"apiGatewayClientFactory");
        AwsWebsocketSender websocketSender = AwsWebsocketSender.awsWebsocketSender(apiGatewayClientFactory);
        httpMaid.addWebsocketSender(AwsWebsocketSender.AWS_WEBSOCKET_SENDER, (WebsocketSender)websocketSender);
        return new AwsWebsocketLambdaEndpoint(httpMaid, region);
    }

    public Map<String, Object> delegate(Map<String, Object> event) {
        AwsLambdaEvent awsLambdaEvent = AwsLambdaEvent.awsLambdaEvent(event);
        return this.handleWebsocketRequest(awsLambdaEvent);
    }

    private Map<String, Object> handleWebsocketRequest(AwsLambdaEvent event) {
        AwsLambdaEvent requestContext = event.getMap(REQUEST_CONTEXT_KEY);
        String eventType = requestContext.getAsString("eventType");
        String connectionId = requestContext.getAsString("connectionId");
        String stage = requestContext.getAsString("stage");
        String apiId = requestContext.getAsString("apiId");
        AwsWebsocketConnectionInformation connectionInformation = AwsWebsocketConnectionInformation.awsWebsocketConnectionInformation(connectionId, stage, apiId, this.region);
        if (CONNECT_EVENT_TYPE.equals(eventType)) {
            this.handleConnect(event, connectionInformation);
            return Collections.emptyMap();
        }
        if (DISCONNECT_EVENT_TYPE.equals(eventType)) {
            this.handleDisconnect(connectionInformation, event);
            return Collections.emptyMap();
        }
        if (MESSAGE_EVENT_TYPE.equals(eventType)) {
            return this.handleMessage(event, connectionInformation);
        }
        throw new UnsupportedOperationException(String.format("Unsupported lambda event type '%s' with event '%s'", eventType, event));
    }

    private void handleConnect(AwsLambdaEvent event, AwsWebsocketConnectionInformation connectionInformation) {
        Map additionalWebsocketData;
        if (this.isAlreadyAuthorized(event)) {
            additionalWebsocketData = AwsWebsocketLambdaEndpoint.extractAdditionalData(event.getMap(REQUEST_CONTEXT_KEY).getMap(AUTHORIZER_KEY));
        } else {
            AuthorizationDecision authorizationDecision = LambdaWebsocketAuthorizer.authorize(event, this.httpMaid);
            if (!authorizationDecision.isAuthorized()) {
                throw AwsWebsocketAuthorizationException.awsWebsocketAuthorizationException();
            }
            additionalWebsocketData = authorizationDecision.additionalData();
        }
        this.httpMaid.handleRequest(() -> {
            RawWebsocketConnectBuilder builder = RawWebsocketConnectBuilder.rawWebsocketConnectBuilder();
            builder.withConnectionInformation(AwsWebsocketSender.AWS_WEBSOCKET_SENDER, (ConnectionInformation)connectionInformation);
            builder.withAdditionalMetaData(AwsLambdaEvent.AWS_LAMBDA_EVENT, (Object)event);
            QueryParameters queryParameters = WebsocketEventUtils.extractQueryParameters(event);
            builder.withQueryParameters(queryParameters);
            Headers headers = WebsocketEventUtils.extractHeaders(event);
            builder.withHeaders(headers);
            builder.withAdditionalMetaData(WebsocketMetaDataKeys.ADDITIONAL_WEBSOCKET_DATA, (Object)additionalWebsocketData);
            return builder.build();
        }, ignored -> {});
    }

    private void handleDisconnect(AwsWebsocketConnectionInformation connectionInformation, AwsLambdaEvent event) {
        this.httpMaid.handleRequest(() -> RawWebsocketDisconnect.rawWebsocketDisconnect((ConnectionInformation)connectionInformation, Map.of(AwsLambdaEvent.AWS_LAMBDA_EVENT, event)), response -> {});
    }

    private Map<String, Object> handleMessage(AwsLambdaEvent event, ConnectionInformation connectionInformation) {
        return (Map)this.httpMaid.handleRequestSynchronously(() -> {
            String body = event.getAsString("body");
            Map<MetaDataKey, AwsLambdaEvent> additionalMetaData = Map.of(AwsLambdaEvent.AWS_LAMBDA_EVENT, event);
            if (this.isAlreadyAuthorized(event)) {
                AwsLambdaEvent authorizerContext = event.getMap(REQUEST_CONTEXT_KEY).getMap(AUTHORIZER_KEY);
                String serializedEvent = authorizerContext.getAsString("event");
                Map<String, Object> authorizerEventMap = MapDeserializer.mapFromString(serializedEvent);
                AwsLambdaEvent authorizerEvent = AwsLambdaEvent.awsLambdaEvent(authorizerEventMap);
                QueryParameters queryParameters = WebsocketEventUtils.extractQueryParameters(authorizerEvent);
                Headers headers = WebsocketEventUtils.extractHeaders(authorizerEvent);
                Map<String, Object> additionalData = AwsWebsocketLambdaEndpoint.extractAdditionalData(authorizerContext);
                return RawWebsocketMessage.rawWebsocketMessageWithMetaData((ConnectionInformation)connectionInformation, (String)body, (QueryParameters)queryParameters, (Headers)headers, additionalData, additionalMetaData);
            }
            return RawWebsocketMessage.rawWebsocketMessage((ConnectionInformation)connectionInformation, (String)body, additionalMetaData);
        }, response -> {
            LinkedHashMap responseMap = new LinkedHashMap();
            response.optionalStringBody().ifPresent(s -> responseMap.put("body", s));
            return responseMap;
        });
    }

    private boolean isAlreadyAuthorized(AwsLambdaEvent event) {
        AwsLambdaEvent context = event.getMap(REQUEST_CONTEXT_KEY);
        return context.containsKey(AUTHORIZER_KEY);
    }

    private static Map<String, Object> extractAdditionalData(AwsLambdaEvent authorizerContext) {
        String serializedAdditionalWebsocketData = authorizerContext.getAsString("additionalData");
        return MapDeserializer.mapFromString(serializedAdditionalWebsocketData);
    }

    @Generated
    public String toString() {
        return "AwsWebsocketLambdaEndpoint(httpMaid=" + this.httpMaid + ", region=" + this.region + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AwsWebsocketLambdaEndpoint)) {
            return false;
        }
        AwsWebsocketLambdaEndpoint other = (AwsWebsocketLambdaEndpoint)o;
        HttpMaid this$httpMaid = this.httpMaid;
        HttpMaid other$httpMaid = other.httpMaid;
        if (this$httpMaid == null ? other$httpMaid != null : !this$httpMaid.equals(other$httpMaid)) {
            return false;
        }
        String this$region = this.region;
        String other$region = other.region;
        return !(this$region == null ? other$region != null : !this$region.equals(other$region));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpMaid $httpMaid = this.httpMaid;
        result = result * 59 + ($httpMaid == null ? 43 : $httpMaid.hashCode());
        String $region = this.region;
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        return result;
    }

    @Generated
    private AwsWebsocketLambdaEndpoint(HttpMaid httpMaid, String region) {
        this.httpMaid = httpMaid;
        this.region = region;
    }
}

