/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda;

import de.quantummaid.httpmaid.awslambda.AwsWebsocketConnectionInformation;
import de.quantummaid.httpmaid.awslambda.ConnectionFuture;
import de.quantummaid.httpmaid.awslambda.apigateway.ApiGatewayClientFactory;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSender;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.apigatewaymanagementapi.ApiGatewayManagementApiAsyncClient;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionRequest;

public final class AwsWebsocketSender
implements WebsocketSender<AwsWebsocketConnectionInformation> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AwsWebsocketSender.class);
    public static final WebsocketSenderId AWS_WEBSOCKET_SENDER = WebsocketSenderId.websocketSenderId((String)"AWS_WEBSOCKET_SENDER");
    private final ApiGatewayClientFactory clientFactory;

    public static AwsWebsocketSender awsWebsocketSender(ApiGatewayClientFactory clientFactory) {
        return new AwsWebsocketSender(clientFactory);
    }

    public void send(String message, List<AwsWebsocketConnectionInformation> connectionInformations, BiConsumer<AwsWebsocketConnectionInformation, Throwable> onException) {
        Map<String, List<AwsWebsocketConnectionInformation>> groupedByEndpointUrl = connectionInformations.stream().collect(Collectors.groupingBy(AwsWebsocketConnectionInformation::toEndpointUrl));
        groupedByEndpointUrl.forEach((endpointUrl, awsWebsocketConnectionInformations) -> {
            try (ApiGatewayManagementApiAsyncClient client = this.clientFactory.provide((String)endpointUrl);){
                List<ConnectionFuture> futures = awsWebsocketConnectionInformations.stream().map(connectionInformation -> {
                    String connectionId = connectionInformation.connectionId;
                    PostToConnectionRequest request = (PostToConnectionRequest)PostToConnectionRequest.builder().connectionId(connectionId).data(SdkBytes.fromUtf8String((String)message)).build();
                    CompletableFuture future = client.postToConnection(request);
                    return ConnectionFuture.connectionFuture(connectionInformation, future);
                }).collect(Collectors.toList());
                AwsWebsocketSender.waitForAllFutures(futures, onException);
            }
        });
    }

    public void disconnect(List<AwsWebsocketConnectionInformation> connectionInformations, BiConsumer<AwsWebsocketConnectionInformation, Throwable> onException) {
        Map<String, List<AwsWebsocketConnectionInformation>> groupedByEndpointUrl = connectionInformations.stream().collect(Collectors.groupingBy(AwsWebsocketConnectionInformation::toEndpointUrl));
        groupedByEndpointUrl.forEach((endpointUrl, awsWebsocketConnectionInformations) -> {
            try (ApiGatewayManagementApiAsyncClient client = this.clientFactory.provide((String)endpointUrl);){
                List<ConnectionFuture> futures = awsWebsocketConnectionInformations.stream().map(connectionInformation -> {
                    String connectionId = connectionInformation.connectionId;
                    DeleteConnectionRequest request = (DeleteConnectionRequest)DeleteConnectionRequest.builder().connectionId(connectionId).build();
                    CompletableFuture future = client.deleteConnection(request);
                    return ConnectionFuture.connectionFuture(connectionInformation, future);
                }).collect(Collectors.toList());
                AwsWebsocketSender.waitForAllFutures(futures, onException);
            }
        });
    }

    public WebsocketSenderId senderId() {
        return AWS_WEBSOCKET_SENDER;
    }

    private static void waitForAllFutures(List<ConnectionFuture> futures, BiConsumer<AwsWebsocketConnectionInformation, Throwable> onException) {
        boolean allDone;
        while (!(allDone = futures.stream().allMatch(ConnectionFuture::isDone))) {
        }
        futures.forEach(future -> future.check(onException));
    }

    @Generated
    public String toString() {
        return "AwsWebsocketSender(clientFactory=" + this.clientFactory + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AwsWebsocketSender)) {
            return false;
        }
        AwsWebsocketSender other = (AwsWebsocketSender)o;
        ApiGatewayClientFactory this$clientFactory = this.clientFactory;
        ApiGatewayClientFactory other$clientFactory = other.clientFactory;
        return !(this$clientFactory == null ? other$clientFactory != null : !this$clientFactory.equals(other$clientFactory));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiGatewayClientFactory $clientFactory = this.clientFactory;
        result = result * 59 + ($clientFactory == null ? 43 : $clientFactory.hashCode());
        return result;
    }

    @Generated
    private AwsWebsocketSender(ApiGatewayClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }
}

