/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda.authorizer;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.awslambda.AwsLambdaEvent;
import de.quantummaid.httpmaid.awslambda.EventUtils;
import de.quantummaid.httpmaid.awslambda.WebsocketEventUtils;
import de.quantummaid.httpmaid.awslambda.authorizer.AuthorizationDecisionMapper;
import de.quantummaid.httpmaid.awslambda.authorizer.LambdaAuthorizer;
import de.quantummaid.httpmaid.awslambda.authorizer.MapSerializer;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.websockets.authorization.AuthorizationDecision;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketAuthorizationBuilder;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LambdaWebsocketAuthorizer
implements LambdaAuthorizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LambdaWebsocketAuthorizer.class);
    public static final String ADDITIONAL_DATA_KEY = "additionalData";
    public static final String AUTHORIZER_EVENT_KEY = "event";
    private final HttpMaid httpMaid;

    public static LambdaWebsocketAuthorizer lambdaWebsocketAuthorizer(HttpMaid httpMaid) {
        NotNullValidator.validateNotNull((Object)httpMaid, (String)"httpMaid");
        return new LambdaWebsocketAuthorizer(httpMaid);
    }

    @Override
    public Map<String, Object> delegate(Map<String, Object> event) {
        AwsLambdaEvent awsLambdaEvent = AwsLambdaEvent.awsLambdaEvent(event);
        String methodArn = EventUtils.extractMethodArn((AwsLambdaEvent)awsLambdaEvent);
        log.debug("extracted methodArn: {}", (Object)methodArn);
        AuthorizationDecision decision = LambdaWebsocketAuthorizer.authorize(awsLambdaEvent, this.httpMaid);
        Map additionalData = decision.additionalData();
        String serializedAdditionalData = MapSerializer.toString(additionalData);
        String serializedEvent = MapSerializer.toString(event);
        Map<String, Object> authorizerContext = Map.of(ADDITIONAL_DATA_KEY, serializedAdditionalData, AUTHORIZER_EVENT_KEY, serializedEvent);
        String principalId = UUID.randomUUID().toString();
        return AuthorizationDecisionMapper.mapAuthorizationDecision(decision.isAuthorized(), methodArn, principalId, authorizerContext);
    }

    public static AuthorizationDecision authorize(AwsLambdaEvent event, HttpMaid httpMaid) {
        return (AuthorizationDecision)httpMaid.handleRequestSynchronously(() -> {
            RawWebsocketAuthorizationBuilder builder = RawWebsocketAuthorizationBuilder.rawWebsocketAuthorizationBuilder();
            builder.withAdditionalMetaData(AwsLambdaEvent.AWS_LAMBDA_EVENT, (Object)event);
            QueryParameters queryParameters = WebsocketEventUtils.extractQueryParameters(event);
            builder.withQueryParameters(queryParameters);
            Headers headers = WebsocketEventUtils.extractHeaders(event);
            builder.withHeaders(headers);
            return builder.build();
        }, response -> (AuthorizationDecision)response.metaData().get(AuthorizationDecision.AUTHORIZATION_DECISION));
    }

    @Generated
    private LambdaWebsocketAuthorizer(HttpMaid httpMaid) {
        this.httpMaid = httpMaid;
    }
}

