/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda.registry;

import de.quantummaid.httpmaid.awslambda.registry.EntryDeserializer;
import de.quantummaid.httpmaid.awslambda.registry.queryexecutor.DefaultQueryExecutor;
import de.quantummaid.httpmaid.awslambda.registry.queryexecutor.QueryExecutor;
import de.quantummaid.httpmaid.awslambda.repository.Repository;
import de.quantummaid.httpmaid.awslambda.repository.dynamodb.DynamoDbRepository;
import de.quantummaid.httpmaid.websockets.criteria.WebsocketCriteria;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class DynamoDbWebsocketRegistry
implements WebsocketRegistry {
    private final Repository repository;
    private final QueryExecutor queryExecutor;

    public static DynamoDbWebsocketRegistry dynamoDbWebsocketRegistry(Repository repository) {
        QueryExecutor defaultQueryExecutor = DefaultQueryExecutor.defaultQueryExecutor();
        return DynamoDbWebsocketRegistry.dynamoDbWebsocketRegistry(repository, defaultQueryExecutor);
    }

    public static DynamoDbWebsocketRegistry dynamoDbWebsocketRegistry(Repository repository, QueryExecutor queryExecutor) {
        return new DynamoDbWebsocketRegistry(repository, queryExecutor);
    }

    public static DynamoDbWebsocketRegistry dynamoDbWebsocketRegistry(String tableName, String primaryKey) {
        DynamoDbRepository repository = DynamoDbRepository.dynamoDbRepository(tableName, primaryKey);
        return DynamoDbWebsocketRegistry.dynamoDbWebsocketRegistry(repository);
    }

    public List<WebsocketRegistryEntry> connections(WebsocketCriteria criteria) {
        return this.queryExecutor.connections(criteria, this.repository);
    }

    public WebsocketRegistryEntry byConnectionInformation(ConnectionInformation connectionInformation) {
        String key = connectionInformation.uniqueIdentifier();
        Map<String, Object> map = this.repository.load(key);
        return EntryDeserializer.deserializeEntry(map);
    }

    public void addConnection(WebsocketRegistryEntry entry) {
        ConnectionInformation connectionInformation = entry.connectionInformation();
        String key = connectionInformation.uniqueIdentifier();
        Map<String, Object> map = EntryDeserializer.serializeEntry(entry);
        this.repository.store(key, map);
    }

    public void removeConnection(ConnectionInformation connectionInformation) {
        String key = connectionInformation.uniqueIdentifier();
        this.repository.delete(key);
    }

    public long countConnections() {
        return this.connections(WebsocketCriteria.websocketCriteria()).size();
    }

    @Generated
    public String toString() {
        return "DynamoDbWebsocketRegistry(repository=" + this.repository + ", queryExecutor=" + this.queryExecutor + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamoDbWebsocketRegistry)) {
            return false;
        }
        DynamoDbWebsocketRegistry other = (DynamoDbWebsocketRegistry)o;
        Repository this$repository = this.repository;
        Repository other$repository = other.repository;
        if (this$repository == null ? other$repository != null : !this$repository.equals(other$repository)) {
            return false;
        }
        QueryExecutor this$queryExecutor = this.queryExecutor;
        QueryExecutor other$queryExecutor = other.queryExecutor;
        return !(this$queryExecutor == null ? other$queryExecutor != null : !this$queryExecutor.equals(other$queryExecutor));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Repository $repository = this.repository;
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        QueryExecutor $queryExecutor = this.queryExecutor;
        result = result * 59 + ($queryExecutor == null ? 43 : $queryExecutor.hashCode());
        return result;
    }

    @Generated
    private DynamoDbWebsocketRegistry(Repository repository, QueryExecutor queryExecutor) {
        this.repository = repository;
        this.queryExecutor = queryExecutor;
    }
}

