/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.awslambda.registry;

import de.quantummaid.httpmaid.awslambda.AwsWebsocketConnectionInformation;
import de.quantummaid.httpmaid.http.Header;
import de.quantummaid.httpmaid.http.HeaderName;
import de.quantummaid.httpmaid.http.HeaderValue;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.QueryParameter;
import de.quantummaid.httpmaid.http.QueryParameterName;
import de.quantummaid.httpmaid.http.QueryParameterValue;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class EntryDeserializer {
    private EntryDeserializer() {
    }

    public static WebsocketRegistryEntry deserializeEntry(Map<String, Object> map) {
        Map connectionInformationMap = (Map)map.get("connectionInformation");
        String connectionId = (String)connectionInformationMap.get("connectionId");
        String stage = (String)connectionInformationMap.get("stage");
        String apiId = (String)connectionInformationMap.get("apiId");
        String region = (String)connectionInformationMap.get("region");
        AwsWebsocketConnectionInformation connectionInformation = AwsWebsocketConnectionInformation.awsWebsocketConnectionInformation(connectionId, stage, apiId, region);
        String senderId = (String)map.get("senderId");
        List serializedHeaders = (List)map.get("headers");
        List headers = serializedHeaders.stream().map(headerMap -> {
            String name = (String)headerMap.get("name");
            String value = (String)headerMap.get("value");
            return Header.header((HeaderName)HeaderName.headerName((String)name), (HeaderValue)HeaderValue.headerValue((String)value));
        }).collect(Collectors.toList());
        Optional<String> contentType = Optional.ofNullable((String)map.get("contentType"));
        List serializedQueryParameters = (List)map.get("queryParameters");
        List queryParameters = serializedQueryParameters.stream().map(queryParameterMap -> {
            String name = (String)queryParameterMap.get("name");
            String value = (String)queryParameterMap.get("value");
            return QueryParameter.queryParameter((QueryParameterName)QueryParameterName.queryParameterName((String)name), (QueryParameterValue)QueryParameterValue.queryParameterValue((String)value));
        }).collect(Collectors.toList());
        Map additionalData = (Map)map.get("additionalData");
        return WebsocketRegistryEntry.restoreFromStrings((ConnectionInformation)connectionInformation, (String)senderId, (Headers)Headers.headers(headers), contentType, (QueryParameters)QueryParameters.queryParameters(queryParameters), (Map)additionalData);
    }

    public static Map<String, Object> serializeEntry(WebsocketRegistryEntry entry) {
        AwsWebsocketConnectionInformation connectionInformation = (AwsWebsocketConnectionInformation)entry.connectionInformation();
        HashMap<String, String> connectionInformationMap = new HashMap<String, String>();
        connectionInformationMap.put("connectionId", connectionInformation.connectionId);
        connectionInformationMap.put("stage", connectionInformation.stage);
        connectionInformationMap.put("apiId", connectionInformation.apiId);
        connectionInformationMap.put("region", connectionInformation.region);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("connectionInformation", connectionInformationMap);
        map.put("senderId", entry.senderId().asString());
        List headers = entry.headers().asList().stream().map(header -> Map.of("name", header.name().stringValue(), "value", header.value().stringValue())).collect(Collectors.toList());
        map.put("headers", headers);
        String contentType = EntryDeserializer.encodeContentType(entry.contentType());
        map.put("contentType", contentType);
        List queryParameters = entry.queryParameters().asList().stream().map(queryParameter -> Map.of("name", queryParameter.name().stringValue(), "value", queryParameter.value().stringValue())).collect(Collectors.toList());
        map.put("queryParameters", queryParameters);
        map.put("additionalData", entry.additionalData());
        return map;
    }

    private static String encodeContentType(ContentType contentType) {
        if (contentType.isEmpty()) {
            return null;
        }
        return contentType.internalValueForMapping();
    }
}

