/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.dagger.factoryfinding;

import de.quantummaid.httpmaid.dagger.DaggerIntegrationException;
import de.quantummaid.httpmaid.dagger.factory.DaggerFactory;
import de.quantummaid.httpmaid.dagger.factory.ReflectionBasedDaggerFactory;
import de.quantummaid.httpmaid.dagger.factoryfinding.DaggerFactoryFinder;
import de.quantummaid.httpmaid.dagger.factoryfinding.NamePattern;
import java.lang.reflect.Method;

public final class PatternBasedFactoryFinder
implements DaggerFactoryFinder {
    private final NamePattern factoryClassNamePattern;
    private final String factoryConstructorName;
    private final NamePattern factoryMethodNamePattern;

    public static PatternBasedFactoryFinder patternBasedFactoryFinder(NamePattern factoryClassNamePattern, String factoryConstructorName, NamePattern factoryMethodNamePattern) {
        return new PatternBasedFactoryFinder(factoryClassNamePattern, factoryConstructorName, factoryMethodNamePattern);
    }

    @Override
    public DaggerFactory findFactory(Class<?> type) {
        String factoryClassName = this.factoryClassNamePattern.fromClass(type);
        Class<?> factoryClass = PatternBasedFactoryFinder.findFactoryClassByName(factoryClassName, type);
        Method factoryConstructor = PatternBasedFactoryFinder.methodByName(this.factoryConstructorName, factoryClass);
        String factoryMethodName = this.factoryMethodNamePattern.fromClass(type);
        Method factoryMethod = PatternBasedFactoryFinder.methodByName(factoryMethodName, factoryClass);
        return ReflectionBasedDaggerFactory.reflectionBasedDaggerFactory(factoryMethod, factoryConstructor, factoryClass);
    }

    private static Class<?> findFactoryClassByName(String name, Class<?> type) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw DaggerIntegrationException.daggerIntegrationException(String.format("Unable to find Dagger factory for class '%s' at '%s'", type.getName(), name), e);
        }
    }

    private static Method methodByName(String name, Class<?> type) {
        try {
            return type.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw DaggerIntegrationException.daggerIntegrationException(String.format("Cannot find method with name '%s' in class '%s'", name, type.getName()), e);
        }
    }

    public String toString() {
        return "PatternBasedFactoryFinder(factoryClassNamePattern=" + this.factoryClassNamePattern + ", factoryConstructorName=" + this.factoryConstructorName + ", factoryMethodNamePattern=" + this.factoryMethodNamePattern + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatternBasedFactoryFinder)) {
            return false;
        }
        PatternBasedFactoryFinder other = (PatternBasedFactoryFinder)o;
        NamePattern this$factoryClassNamePattern = this.factoryClassNamePattern;
        NamePattern other$factoryClassNamePattern = other.factoryClassNamePattern;
        if (this$factoryClassNamePattern == null ? other$factoryClassNamePattern != null : !this$factoryClassNamePattern.equals(other$factoryClassNamePattern)) {
            return false;
        }
        String this$factoryConstructorName = this.factoryConstructorName;
        String other$factoryConstructorName = other.factoryConstructorName;
        if (this$factoryConstructorName == null ? other$factoryConstructorName != null : !this$factoryConstructorName.equals(other$factoryConstructorName)) {
            return false;
        }
        NamePattern this$factoryMethodNamePattern = this.factoryMethodNamePattern;
        NamePattern other$factoryMethodNamePattern = other.factoryMethodNamePattern;
        return !(this$factoryMethodNamePattern == null ? other$factoryMethodNamePattern != null : !this$factoryMethodNamePattern.equals(other$factoryMethodNamePattern));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NamePattern $factoryClassNamePattern = this.factoryClassNamePattern;
        result = result * 59 + ($factoryClassNamePattern == null ? 43 : $factoryClassNamePattern.hashCode());
        String $factoryConstructorName = this.factoryConstructorName;
        result = result * 59 + ($factoryConstructorName == null ? 43 : $factoryConstructorName.hashCode());
        NamePattern $factoryMethodNamePattern = this.factoryMethodNamePattern;
        result = result * 59 + ($factoryMethodNamePattern == null ? 43 : $factoryMethodNamePattern.hashCode());
        return result;
    }

    private PatternBasedFactoryFinder(NamePattern factoryClassNamePattern, String factoryConstructorName, NamePattern factoryMethodNamePattern) {
        this.factoryClassNamePattern = factoryClassNamePattern;
        this.factoryConstructorName = factoryConstructorName;
        this.factoryMethodNamePattern = factoryMethodNamePattern;
    }
}

