/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events;

import de.quantummaid.eventmaid.configuration.AsynchronousConfiguration;
import de.quantummaid.eventmaid.messagebus.MessageBus;
import de.quantummaid.eventmaid.messagebus.MessageBusBuilder;
import de.quantummaid.eventmaid.messagebus.MessageBusType;
import de.quantummaid.eventmaid.messagebus.exception.MessageBusExceptionHandler;
import de.quantummaid.eventmaid.processingcontext.EventType;
import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.ChainRegistry;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.chains.rules.Action;
import de.quantummaid.httpmaid.chains.rules.Drop;
import de.quantummaid.httpmaid.chains.rules.Jump;
import de.quantummaid.httpmaid.closing.ClosingActions;
import de.quantummaid.httpmaid.events.Event;
import de.quantummaid.httpmaid.events.EventFactory;
import de.quantummaid.httpmaid.events.EventsChains;
import de.quantummaid.httpmaid.events.LoggingExceptionHandler;
import de.quantummaid.httpmaid.events.ResponseMapExtractor;
import de.quantummaid.httpmaid.events.enriching.EnrichableMap;
import de.quantummaid.httpmaid.events.enriching.PerEventEnrichers;
import de.quantummaid.httpmaid.events.enriching.enrichers.PathParameterEnricher;
import de.quantummaid.httpmaid.events.extraction.PerEventExtractors;
import de.quantummaid.httpmaid.events.processors.BroadcastingProcessor;
import de.quantummaid.httpmaid.events.processors.DetermineEventProcessor;
import de.quantummaid.httpmaid.events.processors.DispatchEventProcessor;
import de.quantummaid.httpmaid.events.processors.PerRequestEnrichersProcessor;
import de.quantummaid.httpmaid.events.processors.PerRequestExtractorsProcessor;
import de.quantummaid.httpmaid.events.processors.UnwrapDispatchingExceptionProcessor;
import de.quantummaid.httpmaid.generator.GenerationCondition;
import de.quantummaid.httpmaid.generator.Generator;
import de.quantummaid.httpmaid.generator.Generators;
import de.quantummaid.httpmaid.handler.distribution.HandlerDistributors;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.broadcast.Broadcasters;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;

public final class EventModule
implements ChainModule {
    public static final MetaDataKey<MessageBus> MESSAGE_BUS = MetaDataKey.metaDataKey((String)"MESSAGE_BUS");
    public static final MetaDataKey<Boolean> IS_EXTERNAL_EVENT = MetaDataKey.metaDataKey((String)"IS_EXTERNAL_EVENT");
    public static final MetaDataKey<EventType> EVENT_TYPE = MetaDataKey.metaDataKey((String)"EVENT_TYPE");
    public static final MetaDataKey<Event> EVENT = MetaDataKey.metaDataKey((String)"EVENT");
    public static final MetaDataKey<Optional<Object>> RECEIVED_EVENT = MetaDataKey.metaDataKey((String)"RECEIVED_EVENT");
    private static final int DEFAULT_POOL_SIZE = 4;
    private MessageBus messageBus;
    private boolean closeMessageBusOnClose = true;
    private final List<Generator<EventType>> eventTypeGenerators = new LinkedList<Generator<EventType>>();
    private final Map<EventType, EventFactory> eventFactories = new HashMap<EventType, EventFactory>();
    private final Map<EventType, PerEventEnrichers> enrichers = new HashMap<EventType, PerEventEnrichers>();
    private final Map<EventType, PerEventExtractors> extractors = new HashMap<EventType, PerEventExtractors>();
    private final List<ResponseMapExtractor> responseMapExtractors = new LinkedList<ResponseMapExtractor>();

    public static EventModule eventModule() {
        EventModule eventModule = new EventModule();
        MessageBus defaultMessageBus = MessageBusBuilder.aMessageBus().forType(MessageBusType.ASYNCHRONOUS).withAsynchronousConfiguration(AsynchronousConfiguration.constantPoolSizeAsynchronousConfiguration((int)4)).withExceptionHandler((MessageBusExceptionHandler)LoggingExceptionHandler.loggingExceptionHandler()).build();
        eventModule.setMessageBus(defaultMessageBus);
        return eventModule;
    }

    public void addEnricher(EventType eventType, Consumer<PerEventEnrichers> enricher) {
        if (!this.enrichers.containsKey(eventType)) {
            this.enrichers.put(eventType, PerEventEnrichers.perEventEnrichers());
        }
        PerEventEnrichers perEventEnrichers = this.enrichers.get(eventType);
        enricher.accept(perEventEnrichers);
    }

    public void addExtractor(EventType eventType, Consumer<PerEventExtractors> extractor) {
        if (!this.extractors.containsKey(eventType)) {
            this.extractors.put(eventType, PerEventExtractors.perEventExtractors());
        }
        PerEventExtractors perEventExtractors = this.extractors.get(eventType);
        extractor.accept(perEventExtractors);
    }

    public void setMessageBus(MessageBus messageBus) {
        this.messageBus = messageBus;
    }

    public void setCloseMessageBusOnClose(boolean closeMessageBusOnClose) {
        this.closeMessageBusOnClose = closeMessageBusOnClose;
    }

    public void addResponseMapExtractor(ResponseMapExtractor extractor) {
        Validators.validateNotNull((Object)extractor, (String)"extractor");
        this.responseMapExtractors.add(extractor);
    }

    public void addEventMapping(EventType eventType, GenerationCondition condition) {
        this.addEventMapping(eventType, condition, object -> EnrichableMap.emptyEnrichableMap());
        List pathParameters = condition.pathParameters();
        pathParameters.forEach(name -> {
            PathParameterEnricher enricher = PathParameterEnricher.pathParameterEnricher(name, name);
            this.addEnricher(eventType, perEventEnrichers -> perEventEnrichers.addPathParameterEnricher(enricher));
        });
    }

    public void addEventMapping(EventType eventType, GenerationCondition condition, EventFactory eventFactory) {
        Validators.validateNotNull((Object)eventType, (String)"eventType");
        Validators.validateNotNull((Object)condition, (String)"condition");
        Validators.validateNotNull((Object)eventFactory, (String)"eventFactory");
        Generator eventTypeGenerator = Generator.generator((Object)eventType, (GenerationCondition)condition);
        this.eventTypeGenerators.add((Generator<EventType>)eventTypeGenerator);
        this.setEventFactoryFor(eventType, eventFactory);
    }

    public void setEventFactoryFor(EventType eventType, EventFactory eventFactory) {
        Validators.validateNotNull((Object)eventType, (String)"eventType");
        Validators.validateNotNull((Object)eventFactory, (String)"eventFactory");
        this.eventFactories.put(eventType, eventFactory);
    }

    public void init(MetaData configurationMetaData) {
        HandlerDistributors handlerDistributors = (HandlerDistributors)configurationMetaData.get(HandlerDistributors.HANDLER_DISTRIBUTORS);
        handlerDistributors.register(handler -> handler.handler() instanceof EventType, handler -> {
            this.addEventMapping((EventType)handler.handler(), handler.condition());
            return Collections.emptyList();
        });
        configurationMetaData.set(MESSAGE_BUS, (Object)this.messageBus);
    }

    public void register(ChainExtender extender) {
        extender.appendProcessor(HttpMaidChains.DETERMINE_HANDLER, DetermineEventProcessor.determineEventProcessor((Generators<EventType>)Generators.generators(this.eventTypeGenerators)));
        extender.routeIfSet(HttpMaidChains.PREPARE_RESPONSE, (Action)Jump.jumpTo((ChainName)EventsChains.MAP_REQUEST_TO_EVENT), EVENT_TYPE);
        extender.createChain(EventsChains.MAP_REQUEST_TO_EVENT, (Action)Jump.jumpTo((ChainName)EventsChains.SUBMIT_EVENT), (Action)Jump.jumpTo((ChainName)HttpMaidChains.EXCEPTION_OCCURRED));
        extender.appendProcessor(EventsChains.MAP_REQUEST_TO_EVENT, metaData -> {
            Object unmarshalled = metaData.getOptional(HttpMaidChainKeys.UNMARSHALLED_REQUEST_BODY).orElse(null);
            EventType eventType = (EventType)metaData.get(EVENT_TYPE);
            EventFactory eventFactory = this.eventFactories.get(eventType);
            EnrichableMap map = eventFactory.createEvent(unmarshalled);
            Event event = Event.event(map);
            metaData.set(EVENT, (Object)event);
        });
        extender.appendProcessor(EventsChains.MAP_REQUEST_TO_EVENT, PerRequestEnrichersProcessor.enrichersProcessor(this.enrichers));
        Broadcasters broadcasters = (Broadcasters)extender.getMetaDatum(Broadcasters.BROADCASTERS);
        extender.appendProcessor(EventsChains.MAP_REQUEST_TO_EVENT, (Processor)BroadcastingProcessor.broadcastingProcessor(broadcasters));
        extender.createChain(EventsChains.SUBMIT_EVENT, (Action)Jump.jumpTo((ChainName)EventsChains.MAP_EVENT_TO_RESPONSE), (Action)Jump.jumpTo((ChainName)HttpMaidChains.EXCEPTION_OCCURRED));
        extender.appendProcessor(EventsChains.SUBMIT_EVENT, DispatchEventProcessor.dispatchEventProcessor(this.messageBus));
        extender.createChain(EventsChains.MAP_EVENT_TO_RESPONSE, (Action)Jump.jumpTo((ChainName)HttpMaidChains.POST_INVOKE), (Action)Jump.jumpTo((ChainName)HttpMaidChains.EXCEPTION_OCCURRED));
        this.responseMapExtractors.forEach(extractor -> extender.appendProcessor(EventsChains.MAP_EVENT_TO_RESPONSE, (Processor)extractor));
        extender.appendProcessor(EventsChains.MAP_EVENT_TO_RESPONSE, PerRequestExtractorsProcessor.extractorsProcessor(this.extractors));
        extender.appendProcessor(EventsChains.MAP_EVENT_TO_RESPONSE, metaData -> {
            Object map = ((Optional)metaData.get(RECEIVED_EVENT)).orElseGet(HashMap::new);
            metaData.set(HttpMaidChainKeys.RESPONSE_BODY_OBJECT, map);
        });
        extender.appendProcessor(HttpMaidChains.PREPARE_EXCEPTION_RESPONSE, UnwrapDispatchingExceptionProcessor.unwrapDispatchingExceptionProcessor());
        extender.createChain(EventsChains.EXTERNAL_EVENT, (Action)Drop.drop(), (Action)Jump.jumpTo((ChainName)HttpMaidChains.EXCEPTION_OCCURRED));
        extender.routeIfFlagIsSet(HttpMaidChains.INIT, (Action)Jump.jumpTo((ChainName)EventsChains.EXTERNAL_EVENT), IS_EXTERNAL_EVENT);
        ChainRegistry chainRegistry = (ChainRegistry)extender.getMetaDatum(ChainRegistry.CHAIN_REGISTRY);
        if (this.closeMessageBusOnClose) {
            ClosingActions closingActions = (ClosingActions)chainRegistry.getMetaDatum(ClosingActions.CLOSING_ACTIONS);
            closingActions.addClosingAction(() -> ((MessageBus)this.messageBus).close());
        }
    }

    @Generated
    public String toString() {
        return "EventModule(messageBus=" + this.messageBus + ", closeMessageBusOnClose=" + this.closeMessageBusOnClose + ", eventTypeGenerators=" + this.eventTypeGenerators + ", eventFactories=" + this.eventFactories + ", enrichers=" + this.enrichers + ", extractors=" + this.extractors + ", responseMapExtractors=" + this.responseMapExtractors + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventModule)) {
            return false;
        }
        EventModule other = (EventModule)o;
        if (this.closeMessageBusOnClose != other.closeMessageBusOnClose) {
            return false;
        }
        MessageBus this$messageBus = this.messageBus;
        MessageBus other$messageBus = other.messageBus;
        if (this$messageBus == null ? other$messageBus != null : !this$messageBus.equals(other$messageBus)) {
            return false;
        }
        List<Generator<EventType>> this$eventTypeGenerators = this.eventTypeGenerators;
        List<Generator<EventType>> other$eventTypeGenerators = other.eventTypeGenerators;
        if (this$eventTypeGenerators == null ? other$eventTypeGenerators != null : !((Object)this$eventTypeGenerators).equals(other$eventTypeGenerators)) {
            return false;
        }
        Map<EventType, EventFactory> this$eventFactories = this.eventFactories;
        Map<EventType, EventFactory> other$eventFactories = other.eventFactories;
        if (this$eventFactories == null ? other$eventFactories != null : !((Object)this$eventFactories).equals(other$eventFactories)) {
            return false;
        }
        Map<EventType, PerEventEnrichers> this$enrichers = this.enrichers;
        Map<EventType, PerEventEnrichers> other$enrichers = other.enrichers;
        if (this$enrichers == null ? other$enrichers != null : !((Object)this$enrichers).equals(other$enrichers)) {
            return false;
        }
        Map<EventType, PerEventExtractors> this$extractors = this.extractors;
        Map<EventType, PerEventExtractors> other$extractors = other.extractors;
        if (this$extractors == null ? other$extractors != null : !((Object)this$extractors).equals(other$extractors)) {
            return false;
        }
        List<ResponseMapExtractor> this$responseMapExtractors = this.responseMapExtractors;
        List<ResponseMapExtractor> other$responseMapExtractors = other.responseMapExtractors;
        return !(this$responseMapExtractors == null ? other$responseMapExtractors != null : !((Object)this$responseMapExtractors).equals(other$responseMapExtractors));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.closeMessageBusOnClose ? 79 : 97);
        MessageBus $messageBus = this.messageBus;
        result = result * 59 + ($messageBus == null ? 43 : $messageBus.hashCode());
        List<Generator<EventType>> $eventTypeGenerators = this.eventTypeGenerators;
        result = result * 59 + ($eventTypeGenerators == null ? 43 : ((Object)$eventTypeGenerators).hashCode());
        Map<EventType, EventFactory> $eventFactories = this.eventFactories;
        result = result * 59 + ($eventFactories == null ? 43 : ((Object)$eventFactories).hashCode());
        Map<EventType, PerEventEnrichers> $enrichers = this.enrichers;
        result = result * 59 + ($enrichers == null ? 43 : ((Object)$enrichers).hashCode());
        Map<EventType, PerEventExtractors> $extractors = this.extractors;
        result = result * 59 + ($extractors == null ? 43 : ((Object)$extractors).hashCode());
        List<ResponseMapExtractor> $responseMapExtractors = this.responseMapExtractors;
        result = result * 59 + ($responseMapExtractors == null ? 43 : ((Object)$responseMapExtractors).hashCode());
        return result;
    }

    @Generated
    private EventModule() {
    }
}

