/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events.mapper;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.PathParameters;
import de.quantummaid.httpmaid.http.QueryParameters;
import java.util.HashMap;
import java.util.Map;

@FunctionalInterface
public interface RequestToEventMapper {
    public static RequestToEventMapper byDirectlyMappingAllData() {
        return metaData -> {
            HashMap eventMap = new HashMap();
            eventMap.putAll(((QueryParameters)metaData.get(HttpMaidChainKeys.QUERY_PARAMETERS)).asStringMap());
            eventMap.putAll(((PathParameters)metaData.get(HttpMaidChainKeys.PATH_PARAMETERS)).asStringMap());
            eventMap.putAll(((Headers)metaData.get(HttpMaidChainKeys.REQUEST_HEADERS)).asStringMap());
            metaData.getOptional(HttpMaidChainKeys.AUTHENTICATION_INFORMATION).ifPresent(info -> eventMap.put("AUTHENTICATION_INFORMATION", info));
            metaData.getOptional(HttpMaidChainKeys.REQUEST_BODY_MAP).ifPresent(eventMap::putAll);
            return eventMap;
        };
    }

    public static RequestToEventMapper usingOnlyTheBody() {
        return metaData -> {
            HashMap eventMap = new HashMap();
            metaData.getOptional(HttpMaidChainKeys.REQUEST_BODY_MAP).ifPresent(eventMap::putAll);
            return eventMap;
        };
    }

    public Map<String, Object> map(MetaData var1);
}

