/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events.processors;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.events.EventModule;
import de.quantummaid.httpmaid.events.mapper.EventToResponseMapper;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Map;
import java.util.Optional;

public final class SerializationProcessor
implements Processor {
    private final EventToResponseMapper eventToResponseMapper;

    public static Processor serializationProcessor(EventToResponseMapper eventToResponseMapper) {
        Validators.validateNotNull((Object)eventToResponseMapper, (String)"eventToResponseMapper");
        return new SerializationProcessor(eventToResponseMapper);
    }

    public void apply(MetaData metaData) {
        Optional eventReturnValue = (Optional)metaData.get(EventModule.RECEIVED_EVENT);
        eventReturnValue.ifPresent(value -> this.eventToResponseMapper.map((Map<String, Object>)value, metaData));
    }

    public String toString() {
        return "SerializationProcessor(eventToResponseMapper=" + this.eventToResponseMapper + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializationProcessor)) {
            return false;
        }
        SerializationProcessor other = (SerializationProcessor)o;
        EventToResponseMapper this$eventToResponseMapper = this.eventToResponseMapper;
        EventToResponseMapper other$eventToResponseMapper = other.eventToResponseMapper;
        return !(this$eventToResponseMapper == null ? other$eventToResponseMapper != null : !this$eventToResponseMapper.equals(other$eventToResponseMapper));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventToResponseMapper $eventToResponseMapper = this.eventToResponseMapper;
        result = result * 59 + ($eventToResponseMapper == null ? 43 : $eventToResponseMapper.hashCode());
        return result;
    }

    private SerializationProcessor(EventToResponseMapper eventToResponseMapper) {
        this.eventToResponseMapper = eventToResponseMapper;
    }
}

