/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events.enriching;

import de.quantummaid.httpmaid.events.enriching.Enricher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class Enrichable {
    private final String key;
    private Object value = new HashMap();
    private final List<Enricher> enrichersWithoutOverwrite = new ArrayList<Enricher>();
    private final List<Enricher> enrichersWithOverwrite = new ArrayList<Enricher>();

    public static Enrichable enrichable(String key) {
        return new Enrichable(key);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void enrichWithoutOverwrite(Enricher enricher) {
        this.enrichersWithoutOverwrite.add(enricher);
    }

    public void enrichWithOverwrite(Enricher enricher) {
        this.enrichersWithOverwrite.add(enricher);
    }

    public Object compile() {
        for (Enricher enricher : this.enrichersWithoutOverwrite) {
            this.value = enricher.enrich(this.key, this.value);
        }
        for (Enricher enricher : this.enrichersWithOverwrite) {
            this.value = enricher.enrich(this.key, this.value);
        }
        return this.value;
    }

    public String toString() {
        return "Enrichable(key=" + this.key + ", value=" + this.value + ", enrichersWithoutOverwrite=" + this.enrichersWithoutOverwrite + ", enrichersWithOverwrite=" + this.enrichersWithOverwrite + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Enrichable)) {
            return false;
        }
        Enrichable other = (Enrichable)o;
        String this$key = this.key;
        String other$key = other.key;
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Object this$value = this.value;
        Object other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<Enricher> this$enrichersWithoutOverwrite = this.enrichersWithoutOverwrite;
        List<Enricher> other$enrichersWithoutOverwrite = other.enrichersWithoutOverwrite;
        if (this$enrichersWithoutOverwrite == null ? other$enrichersWithoutOverwrite != null : !((Object)this$enrichersWithoutOverwrite).equals(other$enrichersWithoutOverwrite)) {
            return false;
        }
        List<Enricher> this$enrichersWithOverwrite = this.enrichersWithOverwrite;
        List<Enricher> other$enrichersWithOverwrite = other.enrichersWithOverwrite;
        return !(this$enrichersWithOverwrite == null ? other$enrichersWithOverwrite != null : !((Object)this$enrichersWithOverwrite).equals(other$enrichersWithOverwrite));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Object $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<Enricher> $enrichersWithoutOverwrite = this.enrichersWithoutOverwrite;
        result = result * 59 + ($enrichersWithoutOverwrite == null ? 43 : ((Object)$enrichersWithoutOverwrite).hashCode());
        List<Enricher> $enrichersWithOverwrite = this.enrichersWithOverwrite;
        result = result * 59 + ($enrichersWithOverwrite == null ? 43 : ((Object)$enrichersWithOverwrite).hashCode());
        return result;
    }

    private Enrichable(String key) {
        this.key = key;
    }
}

