/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events;

import de.quantummaid.eventmaid.messageBus.MessageBus;
import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.events.EventModule;
import de.quantummaid.httpmaid.events.RequestMapEnricher;
import de.quantummaid.httpmaid.events.ResponseMapExtractor;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Map;

public final class EventConfigurators {
    private EventConfigurators() {
    }

    public static Configurator toUseTheMessageBus(MessageBus messageBus) {
        Validators.validateNotNull((Object)messageBus, (String)"messageBus");
        return Configurator.configuratorForType(EventModule.class, eventModule -> eventModule.setMessageBus(messageBus));
    }

    public static Configurator toEnrichTheIntermediateMapUsing(RequestMapEnricher enricher) {
        Validators.validateNotNull((Object)enricher, (String)"enricher");
        return Configurator.configuratorForType(EventModule.class, eventModule -> eventModule.addRequestMapEnricher(enricher));
    }

    public static Configurator toEnrichTheIntermediateMapWithAllHeaders() {
        return EventConfigurators.toEnrichTheIntermediateMapUsing((map, request) -> {
            Map headersMap = request.headers().asStringMap();
            map.enrichEitherTopOrSecondLevelWithoutOverwriting(headersMap);
        });
    }

    public static Configurator toEnrichTheIntermediateMapWithAllQueryParameters() {
        return EventConfigurators.toEnrichTheIntermediateMapUsing((map, request) -> {
            Map queryParametersMap = request.queryParameters().asStringMap();
            map.enrichEitherTopOrSecondLevelWithoutOverwriting(queryParametersMap);
        });
    }

    public static Configurator toEnrichTheIntermediateMapWithAllPathParameters() {
        return EventConfigurators.toEnrichTheIntermediateMapUsing((map, request) -> {
            Map pathParametersMap = request.pathParameters().asStringMap();
            map.enrichEitherTopOrSecondLevelWithoutOverwriting(pathParametersMap);
        });
    }

    public static Configurator toEnrichTheIntermediateMapWithAllRequestData() {
        return Configurator.allOf((Configurator[])new Configurator[]{EventConfigurators.toEnrichTheIntermediateMapWithAllQueryParameters(), EventConfigurators.toEnrichTheIntermediateMapWithAllPathParameters(), EventConfigurators.toEnrichTheIntermediateMapWithAllHeaders()});
    }

    public static Configurator toEnrichTheIntermediateMapWithTheAuthenticationInformationAs(String key) {
        Validators.validateNotNullNorEmpty((String)key, (String)"key");
        return EventConfigurators.toEnrichTheIntermediateMapUsing((map, request) -> request.authenticationInformation().ifPresent(authenticationInforamtion -> map.enrichOnSecondLevelWithOverwriting(key, authenticationInforamtion)));
    }

    public static Configurator toExtractFromTheResponseMapUsing(ResponseMapExtractor extractor) {
        Validators.validateNotNull((Object)extractor, (String)"extractor");
        return Configurator.configuratorForType(EventModule.class, eventModule -> eventModule.addResponseMapExtractor(extractor));
    }

    public static Configurator toExtractFromTheResponseMapTheHeader(String headerKey, String mapKey) {
        Validators.validateNotNullNorEmpty((String)headerKey, (String)"headerKey");
        Validators.validateNotNullNorEmpty((String)mapKey, (String)"mapKey");
        return EventConfigurators.toExtractFromTheResponseMapUsing((map, response) -> {
            if (!map.containsKey(mapKey)) {
                return;
            }
            String value = (String)map.get(mapKey);
            map.remove(mapKey);
            response.addHeader(headerKey, value);
        });
    }
}

