/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events.processors;

import de.quantummaid.eventmaid.processingContext.EventType;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.events.EventModule;
import de.quantummaid.httpmaid.events.enriching.EnrichableMap;
import de.quantummaid.httpmaid.events.enriching.Enricher;
import de.quantummaid.httpmaid.handler.http.HttpRequest;
import java.util.List;
import java.util.Map;

public final class PerRequestEnrichersProcessor
implements Processor {
    private final Map<EventType, List<Enricher>> enrichers;

    public static Processor enrichersProcessor(Map<EventType, List<Enricher>> enrichers) {
        return new PerRequestEnrichersProcessor(enrichers);
    }

    public void apply(MetaData metaData) {
        metaData.getOptional(EventModule.EVENT_TYPE).ifPresent(eventType -> {
            if (!this.enrichers.containsKey(eventType)) {
                return;
            }
            EnrichableMap event = (EnrichableMap)metaData.get(EventModule.EVENT);
            HttpRequest httpRequest = HttpRequest.httpRequest((MetaData)metaData);
            this.enrichers.get(eventType).forEach(enricher -> enricher.enrich(httpRequest, event));
        });
    }

    public String toString() {
        return "PerRequestEnrichersProcessor(enrichers=" + this.enrichers + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PerRequestEnrichersProcessor)) {
            return false;
        }
        PerRequestEnrichersProcessor other = (PerRequestEnrichersProcessor)o;
        Map<EventType, List<Enricher>> this$enrichers = this.enrichers;
        Map<EventType, List<Enricher>> other$enrichers = other.enrichers;
        return !(this$enrichers == null ? other$enrichers != null : !((Object)this$enrichers).equals(other$enrichers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<EventType, List<Enricher>> $enrichers = this.enrichers;
        result = result * 59 + ($enrichers == null ? 43 : ((Object)$enrichers).hashCode());
        return result;
    }

    private PerRequestEnrichersProcessor(Map<EventType, List<Enricher>> enrichers) {
        this.enrichers = enrichers;
    }
}

