/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events;

import de.quantummaid.eventmaid.messageBus.MessageBus;
import de.quantummaid.eventmaid.processingContext.EventType;
import de.quantummaid.httpmaid.PerRouteConfigurator;
import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.events.EventModule;
import de.quantummaid.httpmaid.events.ResponseMapExtractor;
import de.quantummaid.httpmaid.events.enriching.Enricher;
import de.quantummaid.httpmaid.util.Validators;

public final class EventConfigurators {
    private EventConfigurators() {
    }

    public static Configurator toUseTheMessageBus(MessageBus messageBus) {
        Validators.validateNotNull((Object)messageBus, (String)"messageBus");
        return Configurator.configuratorForType(EventModule.class, eventModule -> eventModule.setMessageBus(messageBus));
    }

    public static Configurator toExtractFromTheResponseMapUsing(ResponseMapExtractor extractor) {
        Validators.validateNotNull((Object)extractor, (String)"extractor");
        return Configurator.configuratorForType(EventModule.class, eventModule -> eventModule.addResponseMapExtractor(extractor));
    }

    public static Configurator toExtractFromTheResponseMapTheHeader(String headerKey, String mapKey) {
        Validators.validateNotNullNorEmpty((String)headerKey, (String)"headerKey");
        Validators.validateNotNullNorEmpty((String)mapKey, (String)"mapKey");
        return EventConfigurators.toExtractFromTheResponseMapUsing((map, response) -> {
            if (!map.containsKey(mapKey)) {
                return;
            }
            String value = (String)map.get(mapKey);
            map.remove(mapKey);
            response.addHeader(headerKey, value);
        });
    }

    public static PerRouteConfigurator mappingPathParameter(String name) {
        return EventConfigurators.mappingPathParameter(name, name);
    }

    public static PerRouteConfigurator mappingPathParameter(String parameterName, String mapKey) {
        return EventConfigurators.mapping((request, map) -> {
            String pathParameter = request.pathParameters().getPathParameter(parameterName);
            map.enrichEitherTopOrSecondLevel(mapKey, pathParameter);
        });
    }

    public static PerRouteConfigurator mappingQueryParameter(String name) {
        return EventConfigurators.mappingQueryParameter(name, name);
    }

    public static PerRouteConfigurator mappingQueryParameter(String parameterName, String mapKey) {
        return EventConfigurators.mapping((request, map) -> {
            String queryParameter = request.queryParameters().getQueryParameter(parameterName);
            map.enrichEitherTopOrSecondLevel(mapKey, queryParameter);
        });
    }

    public static PerRouteConfigurator mappingHeader(String name) {
        return EventConfigurators.mappingHeader(name, name);
    }

    public static PerRouteConfigurator mappingHeader(String headerName, String mapKey) {
        return EventConfigurators.mapping((request, map) -> {
            String header = request.headers().getHeader(headerName);
            map.enrichEitherTopOrSecondLevel(mapKey, header);
        });
    }

    public static PerRouteConfigurator mappingAuthenticationInformation(String key) {
        return EventConfigurators.mapping((request, map) -> {
            Object authenticationInformation = request.authenticationInformation();
            map.enrichEitherTopOrSecondLevel(key, authenticationInformation);
        });
    }

    private static PerRouteConfigurator mapping(Enricher enricher) {
        return (generationCondition, handler, dependencyRegistry) -> {
            if (!(handler instanceof EventType)) {
                return;
            }
            EventModule eventModule = (EventModule)dependencyRegistry.getDependency(EventModule.class);
            eventModule.addEnricher((EventType)handler, enricher);
        };
    }
}

