/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events.processors;

import de.quantummaid.eventmaid.processingContext.EventType;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.events.EventModule;
import de.quantummaid.httpmaid.events.enriching.EnrichableMap;
import de.quantummaid.httpmaid.events.enriching.PerEventEnrichers;
import de.quantummaid.httpmaid.handler.http.HttpRequest;
import java.util.Map;

public final class PerRequestEnrichersProcessor
implements Processor {
    private final Map<EventType, PerEventEnrichers> enrichers;

    public static Processor enrichersProcessor(Map<EventType, PerEventEnrichers> enrichers) {
        return new PerRequestEnrichersProcessor(enrichers);
    }

    public void apply(MetaData metaData) {
        metaData.getOptional(EventModule.EVENT_TYPE).ifPresent(eventType -> {
            if (!this.enrichers.containsKey(eventType)) {
                return;
            }
            EnrichableMap event = (EnrichableMap)metaData.get(EventModule.EVENT);
            HttpRequest httpRequest = HttpRequest.httpRequest((MetaData)metaData);
            this.enrichers.get(eventType).enrich(httpRequest, event);
        });
    }

    public String toString() {
        return "PerRequestEnrichersProcessor(enrichers=" + this.enrichers + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PerRequestEnrichersProcessor)) {
            return false;
        }
        PerRequestEnrichersProcessor other = (PerRequestEnrichersProcessor)o;
        Map<EventType, PerEventEnrichers> this$enrichers = this.enrichers;
        Map<EventType, PerEventEnrichers> other$enrichers = other.enrichers;
        return !(this$enrichers == null ? other$enrichers != null : !((Object)this$enrichers).equals(other$enrichers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<EventType, PerEventEnrichers> $enrichers = this.enrichers;
        result = result * 59 + ($enrichers == null ? 43 : ((Object)$enrichers).hashCode());
        return result;
    }

    private PerRequestEnrichersProcessor(Map<EventType, PerEventEnrichers> enrichers) {
        this.enrichers = enrichers;
    }
}

