/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events;

import de.quantummaid.eventmaid.messageBus.MessageBus;
import de.quantummaid.eventmaid.processingContext.EventType;
import de.quantummaid.httpmaid.PerRouteConfigurator;
import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.events.EventModule;
import de.quantummaid.httpmaid.events.ResponseMapExtractor;
import de.quantummaid.httpmaid.events.enriching.PerEventEnrichers;
import de.quantummaid.httpmaid.events.enriching.enrichers.CookieEnricher;
import de.quantummaid.httpmaid.events.enriching.enrichers.HeaderEnricher;
import de.quantummaid.httpmaid.events.enriching.enrichers.OptionalAuthenticationInformationEnricher;
import de.quantummaid.httpmaid.events.enriching.enrichers.PathParameterEnricher;
import de.quantummaid.httpmaid.events.enriching.enrichers.QueryParameterEnricher;
import de.quantummaid.httpmaid.events.enriching.enrichers.RequiredAuthenticationInformationEnricher;
import de.quantummaid.httpmaid.events.enriching.enrichers.TypeEnricher;
import de.quantummaid.httpmaid.handler.http.HttpRequest;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Optional;
import java.util.function.Consumer;

public final class EventConfigurators {
    private EventConfigurators() {
    }

    public static Configurator toUseTheMessageBus(MessageBus messageBus) {
        Validators.validateNotNull((Object)messageBus, (String)"messageBus");
        return Configurator.configuratorForType(EventModule.class, eventModule -> eventModule.setMessageBus(messageBus));
    }

    public static Configurator toExtractFromTheResponseMapUsing(ResponseMapExtractor extractor) {
        Validators.validateNotNull((Object)extractor, (String)"extractor");
        return Configurator.configuratorForType(EventModule.class, eventModule -> eventModule.addResponseMapExtractor(extractor));
    }

    public static Configurator toExtractFromTheResponseMapTheHeader(String headerKey, String mapKey) {
        Validators.validateNotNullNorEmpty((String)headerKey, (String)"headerKey");
        Validators.validateNotNullNorEmpty((String)mapKey, (String)"mapKey");
        return EventConfigurators.toExtractFromTheResponseMapUsing((map, response) -> {
            if (!map.containsKey(mapKey)) {
                return;
            }
            String value = (String)map.get(mapKey);
            map.remove(mapKey);
            response.addHeader(headerKey, value);
        });
    }

    public static PerRouteConfigurator mappingPathParameter(String name) {
        return EventConfigurators.mappingPathParameter(name, name);
    }

    public static PerRouteConfigurator mappingPathParameter(String parameterName, String mapKey) {
        PathParameterEnricher enricher = PathParameterEnricher.pathParameterEnricher(parameterName, mapKey);
        return EventConfigurators.mapping(perEventEnrichers -> perEventEnrichers.addPathParameterEnricher(enricher));
    }

    public static PerRouteConfigurator ignorePathParameter(String name) {
        PathParameterEnricher enricher = PathParameterEnricher.pathParameterEnricher(name, name);
        return EventConfigurators.mapping(perEventEnrichers -> perEventEnrichers.removePathParameterEnricher(enricher));
    }

    public static PerRouteConfigurator mappingQueryParameter(String name) {
        return EventConfigurators.mappingQueryParameter(name, name);
    }

    public static PerRouteConfigurator mappingQueryParameter(String parameterName, String mapKey) {
        QueryParameterEnricher enricher = QueryParameterEnricher.queryParameterEnricher(parameterName, mapKey);
        return EventConfigurators.mapping(perEventEnrichers -> perEventEnrichers.addQueryParameterEnricher(enricher));
    }

    public static PerRouteConfigurator mappingHeader(String name) {
        return EventConfigurators.mappingHeader(name, name);
    }

    public static PerRouteConfigurator mappingHeader(String headerName, String mapKey) {
        HeaderEnricher enricher = HeaderEnricher.headerEnricher(headerName, mapKey);
        return EventConfigurators.mapping(perEventEnrichers -> perEventEnrichers.addHeaderEnricher(enricher));
    }

    public static PerRouteConfigurator mappingCookie(String name) {
        return EventConfigurators.mappingCookie(name, name);
    }

    public static PerRouteConfigurator mappingCookie(String cookieName, String mapKey) {
        CookieEnricher enricher = CookieEnricher.cookieEnricher(cookieName, mapKey);
        return EventConfigurators.mapping(perEventEnrichers -> perEventEnrichers.addCookieEnricher(enricher));
    }

    public static PerRouteConfigurator mappingAuthenticationInformation(String key) {
        RequiredAuthenticationInformationEnricher enricher = RequiredAuthenticationInformationEnricher.requiredAuthenticationInformationEnricher(key);
        return EventConfigurators.mapping(perEventEnrichers -> perEventEnrichers.addAuthenticationInformationEnricher(enricher));
    }

    public static PerRouteConfigurator mappingAuthenticationInformation() {
        TypeEnricher enricher = request -> {
            Object authenticationInformation = request.authenticationInformation();
            return Optional.of(authenticationInformation);
        };
        return EventConfigurators.mapping(perEventEnrichers -> perEventEnrichers.addAuthenticationInformationEnricher(enricher));
    }

    public static PerRouteConfigurator mappingOptionalAuthenticationInformation(String key) {
        OptionalAuthenticationInformationEnricher enricher = OptionalAuthenticationInformationEnricher.optionalAuthenticationInformationEnricher(key);
        return EventConfigurators.mapping(perEventEnrichers -> perEventEnrichers.addAuthenticationInformationEnricher(enricher));
    }

    public static PerRouteConfigurator mappingOptionalAuthenticationInformation() {
        TypeEnricher enricher = HttpRequest::optionalAuthenticationInformation;
        return EventConfigurators.mapping(perEventEnrichers -> perEventEnrichers.addAuthenticationInformationEnricher(enricher));
    }

    private static PerRouteConfigurator mapping(Consumer<PerEventEnrichers> enricher) {
        return (generationCondition, handler, dependencyRegistry) -> {
            if (!(handler instanceof EventType)) {
                return;
            }
            EventModule eventModule = (EventModule)dependencyRegistry.getDependency(EventModule.class);
            eventModule.addEnricher((EventType)handler, enricher);
        };
    }
}

