/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events.processors;

import de.quantummaid.eventmaid.processingContext.EventType;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.events.EventModule;
import de.quantummaid.httpmaid.events.ExternalEventMapping;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Map;

public final class HandleExternalEventProcessor
implements Processor {
    private final Map<EventType, ExternalEventMapping> mappings;

    public static Processor handleExternalEventProcessor(Map<EventType, ExternalEventMapping> mappings) {
        Validators.validateNotNull(mappings, (String)"mappings");
        return new HandleExternalEventProcessor(mappings);
    }

    public void apply(MetaData metaData) {
        EventType eventType = (EventType)metaData.get(EventModule.EVENT_TYPE);
        ExternalEventMapping mapping = this.mappings.get(eventType);
        Validators.validateNotNull((Object)mapping, (String)"mapping");
        mapping.apply(metaData);
    }

    public String toString() {
        return "HandleExternalEventProcessor(mappings=" + this.mappings + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HandleExternalEventProcessor)) {
            return false;
        }
        HandleExternalEventProcessor other = (HandleExternalEventProcessor)o;
        Map<EventType, ExternalEventMapping> this$mappings = this.mappings;
        Map<EventType, ExternalEventMapping> other$mappings = other.mappings;
        return !(this$mappings == null ? other$mappings != null : !((Object)this$mappings).equals(other$mappings));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<EventType, ExternalEventMapping> $mappings = this.mappings;
        result = result * 59 + ($mappings == null ? 43 : ((Object)$mappings).hashCode());
        return result;
    }

    private HandleExternalEventProcessor(Map<EventType, ExternalEventMapping> mappings) {
        this.mappings = mappings;
    }
}

