/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events.backchannel;

import de.quantummaid.eventmaid.messageBus.MessageBus;
import de.quantummaid.eventmaid.processingContext.EventType;
import de.quantummaid.eventmaid.subscribing.AcceptingBehavior;
import de.quantummaid.eventmaid.subscribing.Subscriber;
import de.quantummaid.eventmaid.subscribing.SubscriptionId;
import de.quantummaid.httpmaid.backchannel.BackChannelFactory;
import de.quantummaid.httpmaid.backchannel.BackChannelTrigger;
import de.quantummaid.httpmaid.util.Validators;
import java.util.UUID;

public final class EventsBackChannelFactory
implements BackChannelFactory {
    private final MessageBus messageBus;

    public BackChannelTrigger createTrigger(final Runnable action) {
        Validators.validateNotNull((Object)action, (String)"action");
        EventType eventType = EventsBackChannelFactory.randomEventType();
        this.messageBus.subscribe(eventType, (Subscriber)new Subscriber<Object>(){

            public AcceptingBehavior accept(Object message) {
                action.run();
                return AcceptingBehavior.MESSAGE_ACCEPTED;
            }

            public SubscriptionId getSubscriptionId() {
                return SubscriptionId.newUniqueId();
            }
        });
        return () -> this.messageBus.send(eventType, new Object());
    }

    private static EventType randomEventType() {
        String uuid = UUID.randomUUID().toString();
        return EventType.eventTypeFromString((String)uuid);
    }

    public String toString() {
        return "EventsBackChannelFactory(messageBus=" + this.messageBus + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventsBackChannelFactory)) {
            return false;
        }
        EventsBackChannelFactory other = (EventsBackChannelFactory)o;
        MessageBus this$messageBus = this.messageBus;
        MessageBus other$messageBus = other.messageBus;
        return !(this$messageBus == null ? other$messageBus != null : !this$messageBus.equals(other$messageBus));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MessageBus $messageBus = this.messageBus;
        result = result * 59 + ($messageBus == null ? 43 : $messageBus.hashCode());
        return result;
    }

    private EventsBackChannelFactory(MessageBus messageBus) {
        this.messageBus = messageBus;
    }
}

