/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events.processors;

import de.quantummaid.eventmaid.processingcontext.EventType;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.events.EventModule;
import de.quantummaid.httpmaid.events.extraction.PerEventExtractors;
import de.quantummaid.httpmaid.handler.http.HttpResponse;
import java.util.Map;
import lombok.Generated;

public final class PerRequestExtractorsProcessor
implements Processor {
    private final Map<EventType, PerEventExtractors> extractors;

    public static Processor extractorsProcessor(Map<EventType, PerEventExtractors> extractors) {
        return new PerRequestExtractorsProcessor(extractors);
    }

    public void apply(MetaData metaData) {
        metaData.getOptional(EventModule.EVENT_TYPE).ifPresent(eventType -> {
            if (!this.extractors.containsKey(eventType)) {
                return;
            }
            HttpResponse httpResponse = HttpResponse.httpResponse((MetaData)metaData);
            this.extractors.get(eventType).extract(httpResponse);
        });
    }

    @Generated
    public String toString() {
        return "PerRequestExtractorsProcessor(extractors=" + this.extractors + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PerRequestExtractorsProcessor)) {
            return false;
        }
        PerRequestExtractorsProcessor other = (PerRequestExtractorsProcessor)o;
        Map<EventType, PerEventExtractors> this$extractors = this.extractors;
        Map<EventType, PerEventExtractors> other$extractors = other.extractors;
        return !(this$extractors == null ? other$extractors != null : !((Object)this$extractors).equals(other$extractors));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<EventType, PerEventExtractors> $extractors = this.extractors;
        result = result * 59 + ($extractors == null ? 43 : ((Object)$extractors).hashCode());
        return result;
    }

    @Generated
    private PerRequestExtractorsProcessor(Map<EventType, PerEventExtractors> extractors) {
        this.extractors = extractors;
    }
}

