/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.guice.factories;

import com.google.inject.AbstractModule;
import de.quantummaid.httpmaid.guice.UnclearHowToInstantiateException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

final class SinglePublicConstructorModule<T>
extends AbstractModule {
    private final Class<T> type;
    private final Constructor<T> constructor;

    static <T> AbstractModule singlePublicConstructorModule(Class<T> type) {
        List<Constructor<T>> constructors = SinglePublicConstructorModule.publicConstructors(type);
        if (constructors.size() == 1) {
            Constructor<T> constructor = constructors.get(0);
            return new SinglePublicConstructorModule<T>(type, constructor);
        }
        String constructorsString = constructors.stream().map(Constructor::toGenericString).collect(Collectors.joining(", ", "[", "]"));
        throw UnclearHowToInstantiateException.unclearHowToInstantiateException(String.format("Can only bind classes that have exactly one public constructor. Class '%s' has the following constructors: %s", type.getName(), constructorsString));
    }

    protected void configure() {
        this.bind(this.type).toConstructor(this.constructor);
    }

    private static <T> List<Constructor<T>> publicConstructors(Class<T> type) {
        Constructor<?>[] constructors = type.getConstructors();
        return Arrays.stream(constructors).filter(constructor -> Modifier.isPublic(constructor.getModifiers())).collect(Collectors.toList());
    }

    @Generated
    public String toString() {
        return "SinglePublicConstructorModule(type=" + this.type + ", constructor=" + this.constructor + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinglePublicConstructorModule)) {
            return false;
        }
        SinglePublicConstructorModule other = (SinglePublicConstructorModule)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Class<T> this$type = this.type;
        Class<T> other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Constructor<T> this$constructor = this.constructor;
        Constructor<T> other$constructor = other.constructor;
        return !(this$constructor == null ? other$constructor != null : !((Object)this$constructor).equals(other$constructor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SinglePublicConstructorModule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Class<T> $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Constructor<T> $constructor = this.constructor;
        result = result * 59 + ($constructor == null ? 43 : ((Object)$constructor).hashCode());
        return result;
    }

    @Generated
    private SinglePublicConstructorModule(Class<T> type, Constructor<T> constructor) {
        this.type = type;
        this.constructor = constructor;
    }
}

