/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.guice;

import com.google.inject.Injector;
import com.google.inject.Module;
import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.guice.factories.GuiceUseCaseInstantiatorFactory;
import de.quantummaid.httpmaid.guice.factories.ProvidedInjectorInstantiatorFactory;
import de.quantummaid.httpmaid.usecases.UseCasesModule;
import de.quantummaid.httpmaid.usecases.instantiation.UseCaseInstantiatorFactory;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Arrays;
import java.util.List;

public final class GuiceConfigurators {
    private GuiceConfigurators() {
    }

    public static Configurator toCreateUseCaseInstancesUsingGuice() {
        UseCaseInstantiatorFactory factory = GuiceUseCaseInstantiatorFactory.guiceUseCaseInstantiatorFactory();
        return GuiceConfigurators.guiceConfigurator(factory);
    }

    public static Configurator toCreateUseCaseInstancesUsingGuice(Module ... modules) {
        List<Module> modulesList = Arrays.asList(modules);
        UseCaseInstantiatorFactory factory = GuiceUseCaseInstantiatorFactory.guiceUseCaseInstantiatorFactory(modulesList);
        return GuiceConfigurators.guiceConfigurator(factory);
    }

    public static Configurator toCreateUseCaseInstancesUsingGuice(Injector injector) {
        Validators.validateNotNull((Object)injector, (String)"injector");
        UseCaseInstantiatorFactory factory = ProvidedInjectorInstantiatorFactory.providedInjectorInstantiatorFactory(injector);
        return GuiceConfigurators.guiceConfigurator(factory);
    }

    private static Configurator guiceConfigurator(UseCaseInstantiatorFactory factory) {
        return Configurator.configuratorForType(UseCasesModule.class, useCasesModule -> useCasesModule.setUseCaseInstantiatorFactory(factory));
    }
}

