/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.jetty;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.endpoint.RawHttpRequest;
import de.quantummaid.httpmaid.endpoint.RawHttpRequestBuilder;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.HeadersBuilder;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.http.QueryParametersBuilder;
import de.quantummaid.httpmaid.util.Validators;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

final class JettyEndpointHandler
extends AbstractHandler {
    private final HttpMaid httpMaid;

    static AbstractHandler jettyEndpointHandler(HttpMaid httpMaid) {
        Validators.validateNotNull((Object)httpMaid, (String)"httpMaid");
        return new JettyEndpointHandler(httpMaid);
    }

    public void handle(String target, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.httpMaid.handleRequest(() -> {
            RawHttpRequestBuilder builder = RawHttpRequest.rawHttpRequestBuilder();
            String path = request.getPathInfo();
            builder.withPath(path);
            String method = request.getMethod();
            builder.withMethod(method);
            Headers headers = JettyEndpointHandler.extractHeaders((HttpServletRequest)request);
            builder.withHeaders(headers);
            QueryParameters queryParameters = JettyEndpointHandler.extractQueryParameters((HttpServletRequest)request);
            builder.withQueryParameters(queryParameters);
            ServletInputStream body = request.getInputStream();
            builder.withBody((InputStream)body);
            return builder.build();
        }, response -> {
            response.setHeaders((arg_0, arg_1) -> ((HttpServletResponse)httpServletResponse).addHeader(arg_0, arg_1));
            httpServletResponse.setStatus(response.status());
            ServletOutputStream outputStream = httpServletResponse.getOutputStream();
            response.streamBodyToOutputStream((OutputStream)outputStream);
        });
    }

    private static Headers extractHeaders(HttpServletRequest request) {
        HeadersBuilder headersBuilder = HeadersBuilder.headersBuilder();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration values = request.getHeaders(headerName);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                headersBuilder.withAdditionalHeader(headerName, value);
            }
        }
        return headersBuilder.build();
    }

    private static QueryParameters extractQueryParameters(HttpServletRequest request) {
        Enumeration parameterNames = request.getParameterNames();
        QueryParametersBuilder builder = QueryParameters.builder();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String[] parameterValues = request.getParameterValues(parameterName);
            builder.withParameter(parameterName, Arrays.asList(parameterValues));
        }
        return builder.build();
    }

    @Generated
    private JettyEndpointHandler(HttpMaid httpMaid) {
        this.httpMaid = httpMaid;
    }
}

