/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.jetty;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.util.Streams;
import de.quantummaid.httpmaid.util.Validators;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

final class JettyEndpointHandler
extends AbstractHandler {
    private final HttpMaid httpMaid;

    static AbstractHandler jettyEndpointHandler(HttpMaid httpMaid) {
        Validators.validateNotNull((Object)httpMaid, (String)"httpMaid");
        return new JettyEndpointHandler(httpMaid);
    }

    public void handle(String target, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String method = request.getMethod();
        String path = request.getPathInfo();
        Map<String, List<String>> headers = JettyEndpointHandler.extractHeaders((HttpServletRequest)request);
        Map<String, String> queryParameters = JettyEndpointHandler.extractQueryParameters((HttpServletRequest)request);
        ServletInputStream body = request.getInputStream();
        MetaData metaData = MetaData.emptyMetaData();
        metaData.set(HttpMaidChainKeys.RAW_REQUEST_HEADERS, headers);
        metaData.set(HttpMaidChainKeys.RAW_REQUEST_QUERY_PARAMETERS, queryParameters);
        metaData.set(HttpMaidChainKeys.RAW_METHOD, (Object)method);
        metaData.set(HttpMaidChainKeys.RAW_PATH, (Object)path);
        metaData.set(HttpMaidChainKeys.REQUEST_BODY_STREAM, (Object)body);
        metaData.set(HttpMaidChainKeys.IS_HTTP_REQUEST, (Object)true);
        this.httpMaid.handleRequest(metaData, httpResponse -> {
            Map responseHeaders = (Map)metaData.get(HttpMaidChainKeys.RESPONSE_HEADERS);
            responseHeaders.forEach((arg_0, arg_1) -> ((HttpServletResponse)httpServletResponse).setHeader(arg_0, arg_1));
            int responseStatus = (Integer)metaData.get(HttpMaidChainKeys.RESPONSE_STATUS);
            httpServletResponse.setStatus(responseStatus);
            ServletOutputStream outputStream = httpServletResponse.getOutputStream();
            InputStream inputStream = metaData.getOptional(HttpMaidChainKeys.RESPONSE_STREAM).orElseGet(() -> Streams.stringToInputStream((String)""));
            Streams.streamInputStreamToOutputStream((InputStream)inputStream, (OutputStream)outputStream);
        });
    }

    private static Map<String, List<String>> extractHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String value = request.getHeader(headerName);
            headers.put(headerName, Collections.singletonList(value));
        }
        return headers;
    }

    private static Map<String, String> extractQueryParameters(HttpServletRequest request) {
        Enumeration parameterNames = request.getParameterNames();
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String value = request.getParameter(parameterName);
            queryParameters.put(parameterName, value);
        }
        return queryParameters;
    }

    private JettyEndpointHandler(HttpMaid httpMaid) {
        this.httpMaid = httpMaid;
    }
}

