/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.jetty;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.endpoint.RawRequest;
import de.quantummaid.httpmaid.endpoint.RawRequestBuilder;
import de.quantummaid.httpmaid.util.Validators;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

final class JettyEndpointHandler
extends AbstractHandler {
    private final HttpMaid httpMaid;

    static AbstractHandler jettyEndpointHandler(HttpMaid httpMaid) {
        Validators.validateNotNull((Object)httpMaid, (String)"httpMaid");
        return new JettyEndpointHandler(httpMaid);
    }

    public void handle(String target, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.httpMaid.handleRequest(() -> {
            RawRequestBuilder builder = RawRequest.rawRequestBuilder();
            String path = request.getPathInfo();
            builder.withPath(path);
            String method = request.getMethod();
            builder.withMethod(method);
            Map<String, List<String>> headers = JettyEndpointHandler.extractHeaders((HttpServletRequest)request);
            builder.withHeaders(headers);
            Map<String, String> queryParameters = JettyEndpointHandler.extractQueryParameters((HttpServletRequest)request);
            builder.withQueryParameters(queryParameters);
            ServletInputStream body = request.getInputStream();
            builder.withBody((InputStream)body);
            return builder.build();
        }, response -> {
            response.setHeaders((arg_0, arg_1) -> ((HttpServletResponse)httpServletResponse).setHeader(arg_0, arg_1));
            httpServletResponse.setStatus(response.status());
            ServletOutputStream outputStream = httpServletResponse.getOutputStream();
            response.streamBodyToOutputStream((OutputStream)outputStream);
        });
    }

    private static Map<String, List<String>> extractHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String value = request.getHeader(headerName);
            headers.put(headerName, Collections.singletonList(value));
        }
        return headers;
    }

    private static Map<String, String> extractQueryParameters(HttpServletRequest request) {
        Enumeration parameterNames = request.getParameterNames();
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String value = request.getParameter(parameterName);
            queryParameters.put(parameterName, value);
        }
        return queryParameters;
    }

    @Generated
    private JettyEndpointHandler(HttpMaid httpMaid) {
        this.httpMaid = httpMaid;
    }
}

