/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.jetty;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.closing.ClosingAction;
import de.quantummaid.httpmaid.closing.ClosingActions;
import de.quantummaid.httpmaid.jetty.JettyEndpointException;
import de.quantummaid.httpmaid.jetty.JettyEndpointHandler;
import de.quantummaid.httpmaid.jetty.PortStage;
import lombok.Generated;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;

public final class JettyEndpoint
implements AutoCloseable {
    private final HttpMaid httpMaid;

    public static PortStage jettyEndpointFor(HttpMaid httpMaid) {
        return port -> {
            try {
                Server server = new Server(port);
                HttpConnectionFactory connectionFactory = JettyEndpoint.extractConnectionFactory(server);
                connectionFactory.getHttpConfiguration().setFormEncodedMethods(new String[0]);
                server.setHandler((Handler)JettyEndpointHandler.jettyEndpointHandler(httpMaid));
                server.start();
                ((ClosingActions)httpMaid.getMetaDatum(ClosingActions.CLOSING_ACTIONS)).addClosingAction(JettyEndpoint.closeJetty(server));
            }
            catch (Exception e) {
                throw JettyEndpointException.jettyEndpointException("Could not create Jetty Endpoint", e);
            }
            return new JettyEndpoint(httpMaid);
        };
    }

    private static ClosingAction closeJetty(Server server) {
        return () -> {
            try {
                server.stop();
                server.destroy();
            }
            catch (Exception e) {
                throw JettyEndpointException.jettyEndpointException("Could not stop Jetty Endpoint", e);
            }
        };
    }

    @Override
    public void close() {
        this.httpMaid.close();
    }

    private static HttpConnectionFactory extractConnectionFactory(Server server) {
        Connector[] connectors = server.getConnectors();
        if (connectors.length != 1) {
            throw new UnsupportedOperationException("Jetty does not behave as expected");
        }
        Connector connector = connectors[0];
        ConnectionFactory connectionFactory = connector.getDefaultConnectionFactory();
        if (!(connectionFactory instanceof HttpConnectionFactory)) {
            throw new UnsupportedOperationException("Jetty does not behave as expected");
        }
        return (HttpConnectionFactory)connectionFactory;
    }

    @Generated
    private JettyEndpoint(HttpMaid httpMaid) {
        this.httpMaid = httpMaid;
    }
}

