/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.jsr356;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.jsr356.Jsr356ConnectionInformation;
import de.quantummaid.httpmaid.jsr356.Jsr356MessageHandler;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketConnect;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketConnectBuilder;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketDisconnect;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.sender.NonSerializableConnectionInformation;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import lombok.Generated;

public class Jsr356Endpoint
extends Endpoint {
    private final HttpMaid httpMaid;
    private final Headers headers;
    private final Map<String, Object> additionalWebsocketData;
    private NonSerializableConnectionInformation connectionInformation;

    public static Jsr356Endpoint programmaticJsr356Endpoint(HttpMaid httpMaid, Headers headers, Map<String, Object> additionalWebsocketData) {
        return new Jsr356Endpoint(httpMaid, headers, additionalWebsocketData);
    }

    public synchronized void onOpen(Session session, EndpointConfig config) {
        this.connectionInformation = Jsr356ConnectionInformation.jsr356ConnectionInformation(session);
        this.httpMaid.handleRequest(() -> {
            RawWebsocketConnectBuilder builder = RawWebsocketConnect.rawWebsocketConnectBuilder();
            builder.withNonSerializableConnectionInformation(this.connectionInformation);
            builder.withHeaders(this.headers);
            String queryString = session.getQueryString();
            builder.withEncodedQueryString(queryString);
            builder.withAdditionalMetaData(WebsocketMetaDataKeys.ADDITIONAL_WEBSOCKET_DATA, this.additionalWebsocketData);
            return builder.build();
        }, ignored -> {});
        session.addMessageHandler(Jsr356MessageHandler.jsr356MessageHandler(this.connectionInformation, session, this.httpMaid));
    }

    public synchronized void onClose(Session session, CloseReason closeReason) {
        this.httpMaid.handleRequest(() -> RawWebsocketDisconnect.rawWebsocketDisconnect((ConnectionInformation)this.connectionInformation), response -> {});
    }

    @Generated
    public String toString() {
        return "Jsr356Endpoint(httpMaid=" + this.httpMaid + ", headers=" + this.headers + ", additionalWebsocketData=" + this.additionalWebsocketData + ", connectionInformation=" + this.connectionInformation + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Jsr356Endpoint)) {
            return false;
        }
        Jsr356Endpoint other = (Jsr356Endpoint)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpMaid this$httpMaid = this.httpMaid;
        HttpMaid other$httpMaid = other.httpMaid;
        if (this$httpMaid == null ? other$httpMaid != null : !this$httpMaid.equals(other$httpMaid)) {
            return false;
        }
        Headers this$headers = this.headers;
        Headers other$headers = other.headers;
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        Map<String, Object> this$additionalWebsocketData = this.additionalWebsocketData;
        Map<String, Object> other$additionalWebsocketData = other.additionalWebsocketData;
        if (this$additionalWebsocketData == null ? other$additionalWebsocketData != null : !((Object)this$additionalWebsocketData).equals(other$additionalWebsocketData)) {
            return false;
        }
        NonSerializableConnectionInformation this$connectionInformation = this.connectionInformation;
        NonSerializableConnectionInformation other$connectionInformation = other.connectionInformation;
        return !(this$connectionInformation == null ? other$connectionInformation != null : !this$connectionInformation.equals(other$connectionInformation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Jsr356Endpoint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        HttpMaid $httpMaid = this.httpMaid;
        result = result * 59 + ($httpMaid == null ? 43 : $httpMaid.hashCode());
        Headers $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        Map<String, Object> $additionalWebsocketData = this.additionalWebsocketData;
        result = result * 59 + ($additionalWebsocketData == null ? 43 : ((Object)$additionalWebsocketData).hashCode());
        NonSerializableConnectionInformation $connectionInformation = this.connectionInformation;
        result = result * 59 + ($connectionInformation == null ? 43 : $connectionInformation.hashCode());
        return result;
    }

    @Generated
    private Jsr356Endpoint(HttpMaid httpMaid, Headers headers, Map<String, Object> additionalWebsocketData) {
        this.httpMaid = httpMaid;
        this.headers = headers;
        this.additionalWebsocketData = additionalWebsocketData;
    }
}

