/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.jsr356;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.HeadersBuilder;
import de.quantummaid.httpmaid.jsr356.HandshakeMetaData;
import de.quantummaid.httpmaid.jsr356.Jsr356Endpoint;
import de.quantummaid.httpmaid.jsr356.Jsr356Exception;
import de.quantummaid.httpmaid.websockets.authorization.AuthorizationDecision;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketAuthorizationBuilder;
import java.util.Map;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import lombok.Generated;

public final class Jsr356EndpointConfigurator
extends ServerEndpointConfig.Configurator {
    private final HttpMaid httpMaid;
    private final HandshakeMetaData handshakeMetaData;

    public static ServerEndpointConfig.Configurator jsr356EndpointConfigurator(HttpMaid httpMaid, HandshakeMetaData handshakeMetaData) {
        return new Jsr356EndpointConfigurator(httpMaid, handshakeMetaData);
    }

    public synchronized <T> T getEndpointInstance(Class<T> endpointClass) {
        Headers headers = this.handshakeMetaData.getHeaders();
        Map<String, Object> additionalWebsocketData = this.handshakeMetaData.getAdditionalWebsocketData();
        return (T)((Object)Jsr356Endpoint.programmaticJsr356Endpoint(this.httpMaid, headers, additionalWebsocketData));
    }

    public synchronized void modifyHandshake(ServerEndpointConfig serverEndpointConfig, HandshakeRequest request, HandshakeResponse response) {
        Map requestHeaders = request.getHeaders();
        HeadersBuilder headersBuilder = HeadersBuilder.headersBuilder();
        headersBuilder.withHeadersMap(requestHeaders);
        Headers headers = headersBuilder.build();
        AuthorizationDecision authorizationDecision = (AuthorizationDecision)this.httpMaid.handleRequestSynchronously(() -> {
            RawWebsocketAuthorizationBuilder builder = RawWebsocketAuthorizationBuilder.rawWebsocketAuthorizationBuilder();
            builder.withHeaders(headers);
            String queryString = request.getQueryString();
            builder.withEncodedQueryString(queryString);
            return builder.build();
        }, authorizationResponse -> (AuthorizationDecision)authorizationResponse.metaData().get(AuthorizationDecision.AUTHORIZATION_DECISION));
        if (!authorizationDecision.isAuthorized()) {
            throw Jsr356Exception.jsr356Exception("not authorized");
        }
        this.handshakeMetaData.setHeaders(headers);
        this.handshakeMetaData.setAdditionalWebsocketData(authorizationDecision.additionalData());
    }

    @Generated
    public String toString() {
        return "Jsr356EndpointConfigurator(httpMaid=" + this.httpMaid + ", handshakeMetaData=" + this.handshakeMetaData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Jsr356EndpointConfigurator)) {
            return false;
        }
        Jsr356EndpointConfigurator other = (Jsr356EndpointConfigurator)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpMaid this$httpMaid = this.httpMaid;
        HttpMaid other$httpMaid = other.httpMaid;
        if (this$httpMaid == null ? other$httpMaid != null : !this$httpMaid.equals(other$httpMaid)) {
            return false;
        }
        HandshakeMetaData this$handshakeMetaData = this.handshakeMetaData;
        HandshakeMetaData other$handshakeMetaData = other.handshakeMetaData;
        return !(this$handshakeMetaData == null ? other$handshakeMetaData != null : !((Object)this$handshakeMetaData).equals(other$handshakeMetaData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Jsr356EndpointConfigurator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        HttpMaid $httpMaid = this.httpMaid;
        result = result * 59 + ($httpMaid == null ? 43 : $httpMaid.hashCode());
        HandshakeMetaData $handshakeMetaData = this.handshakeMetaData;
        result = result * 59 + ($handshakeMetaData == null ? 43 : ((Object)$handshakeMetaData).hashCode());
        return result;
    }

    @Generated
    private Jsr356EndpointConfigurator(HttpMaid httpMaid, HandshakeMetaData handshakeMetaData) {
        this.httpMaid = httpMaid;
        this.handshakeMetaData = handshakeMetaData;
    }
}

