/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.jsr356;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.jsr356.Jsr356MessageHandler;
import de.quantummaid.httpmaid.jsr356.SenderHelper;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketConnect;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketConnectBuilder;
import de.quantummaid.httpmaid.websockets.sender.NonSerializableConnectionInformation;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import lombok.Generated;

public class Jsr356Endpoint
extends Endpoint {
    private final HttpMaid httpMaid;
    private final Headers headers;

    public static Jsr356Endpoint programmaticJsr356Endpoint(HttpMaid httpMaid, Headers headers) {
        return new Jsr356Endpoint(httpMaid, headers);
    }

    public void onOpen(Session session, EndpointConfig config) {
        NonSerializableConnectionInformation connectionInformation = message -> SenderHelper.sendMessage(session, message);
        this.httpMaid.handleRequest(() -> {
            RawWebsocketConnectBuilder builder = RawWebsocketConnect.rawWebsocketConnectBuilder();
            builder.withNonSerializableConnectionInformation(connectionInformation);
            builder.withHeaders(this.headers);
            String queryString = session.getQueryString();
            builder.withEncodedQueryString(queryString);
            return builder.build();
        }, response -> {});
        session.addMessageHandler(Jsr356MessageHandler.jsr356MessageHandler(connectionInformation, session, this.httpMaid));
    }

    @Generated
    public String toString() {
        return "Jsr356Endpoint(httpMaid=" + this.httpMaid + ", headers=" + this.headers + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Jsr356Endpoint)) {
            return false;
        }
        Jsr356Endpoint other = (Jsr356Endpoint)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpMaid this$httpMaid = this.httpMaid;
        HttpMaid other$httpMaid = other.httpMaid;
        if (this$httpMaid == null ? other$httpMaid != null : !this$httpMaid.equals(other$httpMaid)) {
            return false;
        }
        Headers this$headers = this.headers;
        Headers other$headers = other.headers;
        return !(this$headers == null ? other$headers != null : !this$headers.equals(other$headers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Jsr356Endpoint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        HttpMaid $httpMaid = this.httpMaid;
        result = result * 59 + ($httpMaid == null ? 43 : $httpMaid.hashCode());
        Headers $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        return result;
    }

    @Generated
    private Jsr356Endpoint(HttpMaid httpMaid, Headers headers) {
        this.httpMaid = httpMaid;
        this.headers = headers;
    }
}

