/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mapmaid.advancedscanner;

import de.quantummaid.httpmaid.mapmaid.advancedscanner.VirtualDeserializer;
import de.quantummaid.httpmaid.mapmaid.advancedscanner.deserialization_wrappers.MethodParameterDeserializationWrapper;
import de.quantummaid.httpmaid.mapmaid.advancedscanner.deserialization_wrappers.MultipleParametersDeserializationWrapper;
import de.quantummaid.httpmaid.usecases.method.UseCaseMethod;
import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.mapmaid.builder.RequiredCapabilities;
import de.quantummaid.mapmaid.builder.customtypes.DeserializationOnlyType;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.identifier.VirtualTypeIdentifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class UseCaseClassScanner {
    private UseCaseClassScanner() {
    }

    public static Map<ResolvedType, MethodParameterDeserializationWrapper> addAllReferencedClassesIn(List<UseCaseMethod> useCaseMethods, MapMaidBuilder builder) {
        NotNullValidator.validateNotNull(useCaseMethods, (String)"useCaseMethods");
        NotNullValidator.validateNotNull((Object)builder, (String)"builder");
        HashMap<ResolvedType, MethodParameterDeserializationWrapper> deserializationWrappers = new HashMap<ResolvedType, MethodParameterDeserializationWrapper>(useCaseMethods.size());
        useCaseMethods.forEach(useCaseMethod -> {
            MethodParameterDeserializationWrapper deserializationWrapper = UseCaseClassScanner.addMethod(useCaseMethod, builder);
            deserializationWrappers.put(useCaseMethod.useCaseClass(), deserializationWrapper);
        });
        return deserializationWrappers;
    }

    private static MethodParameterDeserializationWrapper addMethod(UseCaseMethod method, MapMaidBuilder builder) {
        Map parameters = method.parameters();
        parameters.values().stream().map(GenericType::fromResolvedType).forEach(type -> builder.withType(type, RequiredCapabilities.deserialization(), String.format("because parameter type of method %s", method.describe())));
        method.returnType().ifPresent(type -> {
            GenericType genericType = GenericType.fromResolvedType((ResolvedType)type);
            builder.withType(genericType, RequiredCapabilities.serialization(), String.format("because return type of method %s", method.describe()));
        });
        DeserializationOnlyType<?> virtualType = UseCaseClassScanner.createVirtualObjectFor(method.describe(), parameters);
        builder.deserializing(virtualType);
        return MultipleParametersDeserializationWrapper.multipleParameters(virtualType.type());
    }

    private static DeserializationOnlyType<?> createVirtualObjectFor(String method, Map<String, ResolvedType> parameters) {
        TypeIdentifier typeIdentifier = VirtualTypeIdentifier.uniqueVirtualTypeIdentifier();
        SerializedObjectDeserializer deserializer = VirtualDeserializer.virtualDeserializerFor(method, parameters);
        return DeserializationOnlyType.deserializationOnlyType((TypeIdentifier)typeIdentifier, (TypeDeserializer)deserializer);
    }
}

