/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mapmaid;

import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.marshalling.MarshallingModule;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.mapmaid.MapMaid;
import de.quantummaid.mapmaid.builder.recipes.urlencoded.UrlEncodedMarshallerRecipe;
import de.quantummaid.mapmaid.builder.recipes.urlencoded.UrlEncodedUnmarshaller;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.mapper.marshalling.Unmarshaller;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

final class MapMaidMarshallingMapper {
    private static final Map<MarshallingType<String>, ContentType> DEFAULT_CONTENT_TYPE_MAPPINGS = Map.of(MarshallingType.JSON, ContentType.json(), MarshallingType.XML, ContentType.xml(), MarshallingType.YAML, ContentType.yaml(), UrlEncodedMarshallerRecipe.urlEncoded(), ContentType.formUrlEncoded());
    private static final List<MarshallingType<String>> DEFAULT_SUPPORTED_TYPES_FOR_UNMARSHALLING = Arrays.asList(MarshallingType.JSON, MarshallingType.XML, MarshallingType.YAML, UrlEncodedMarshallerRecipe.urlEncoded());
    private static final List<MarshallingType<String>> DEFAULT_SUPPORTED_TYPES_FOR_MARSHALLING = Arrays.asList(MarshallingType.JSON, MarshallingType.XML, MarshallingType.YAML);
    private final Map<ContentType, MarshallingType<String>> contentTypeMappingsForUnmarshalling = new HashMap<ContentType, MarshallingType<String>>();
    private final Map<ContentType, MarshallingType<String>> contentTypeMappingsForMarshalling = new HashMap<ContentType, MarshallingType<String>>();

    static MapMaidMarshallingMapper mapMaidMarshallingMapper() {
        return new MapMaidMarshallingMapper();
    }

    void addRequestContentTypeToUnmarshallingTypeMapping(ContentType contentType, MarshallingType<String> marshallingType) {
        Validators.validateNotNull((Object)contentType, (String)"contentType");
        Validators.validateNotNull(marshallingType, (String)"marshallingType");
        this.contentTypeMappingsForUnmarshalling.put(contentType, marshallingType);
    }

    void addMarshallingTypeToResponseContentTypeMapping(ContentType contentType, MarshallingType<String> marshallingType) {
        Validators.validateNotNull((Object)contentType, (String)"contentType");
        Validators.validateNotNull(marshallingType, (String)"marshallingType");
        this.contentTypeMappingsForMarshalling.put(contentType, marshallingType);
    }

    void mapMarshalling(MapMaid mapMaid, MarshallingModule marshallingModule) {
        UrlEncodedUnmarshaller urlEncodedMarshaller = UrlEncodedUnmarshaller.urlEncodedUnmarshaller();
        marshallingModule.addUnmarshaller(ContentType.formUrlEncoded(), arg_0 -> ((Unmarshaller)urlEncodedMarshaller).unmarshal(arg_0));
        mapMaid.deserializer().supportedMarshallingTypes().stream().filter(marshallingType -> !this.contentTypeMappingsForUnmarshalling.containsValue(marshallingType)).filter(DEFAULT_SUPPORTED_TYPES_FOR_UNMARSHALLING::contains).forEach(marshallingType -> {
            ContentType contentType = DEFAULT_CONTENT_TYPE_MAPPINGS.get(marshallingType);
            this.contentTypeMappingsForUnmarshalling.put(contentType, (MarshallingType<String>)marshallingType);
        });
        this.contentTypeMappingsForUnmarshalling.forEach((contentType, marshallingType) -> marshallingModule.addUnmarshaller(contentType, input -> mapMaid.deserializer().deserializeToUniversalObject((Object)input, marshallingType)));
        mapMaid.serializer().supportedMarshallingTypes().stream().filter(marshallingType -> !this.contentTypeMappingsForMarshalling.containsValue(marshallingType)).filter(DEFAULT_SUPPORTED_TYPES_FOR_MARSHALLING::contains).forEach(marshallingType -> {
            ContentType contentType = DEFAULT_CONTENT_TYPE_MAPPINGS.get(marshallingType);
            this.contentTypeMappingsForMarshalling.put(contentType, (MarshallingType<String>)marshallingType);
        });
        this.contentTypeMappingsForMarshalling.forEach((contentType, marshallingType) -> marshallingModule.addMarshaller(contentType, map -> (String)mapMaid.serializer().marshalFromUniversalObject(map, marshallingType)));
        if (mapMaid.deserializer().supportedMarshallingTypes().contains(MarshallingType.JSON)) {
            marshallingModule.setDefaultContentTypeProvider(ContentType.json());
        }
    }

    @Generated
    public String toString() {
        return "MapMaidMarshallingMapper(contentTypeMappingsForUnmarshalling=" + this.contentTypeMappingsForUnmarshalling + ", contentTypeMappingsForMarshalling=" + this.contentTypeMappingsForMarshalling + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapMaidMarshallingMapper)) {
            return false;
        }
        MapMaidMarshallingMapper other = (MapMaidMarshallingMapper)o;
        Map<ContentType, MarshallingType<String>> this$contentTypeMappingsForUnmarshalling = this.contentTypeMappingsForUnmarshalling;
        Map<ContentType, MarshallingType<String>> other$contentTypeMappingsForUnmarshalling = other.contentTypeMappingsForUnmarshalling;
        if (this$contentTypeMappingsForUnmarshalling == null ? other$contentTypeMappingsForUnmarshalling != null : !((Object)this$contentTypeMappingsForUnmarshalling).equals(other$contentTypeMappingsForUnmarshalling)) {
            return false;
        }
        Map<ContentType, MarshallingType<String>> this$contentTypeMappingsForMarshalling = this.contentTypeMappingsForMarshalling;
        Map<ContentType, MarshallingType<String>> other$contentTypeMappingsForMarshalling = other.contentTypeMappingsForMarshalling;
        return !(this$contentTypeMappingsForMarshalling == null ? other$contentTypeMappingsForMarshalling != null : !((Object)this$contentTypeMappingsForMarshalling).equals(other$contentTypeMappingsForMarshalling));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<ContentType, MarshallingType<String>> $contentTypeMappingsForUnmarshalling = this.contentTypeMappingsForUnmarshalling;
        result = result * 59 + ($contentTypeMappingsForUnmarshalling == null ? 43 : ((Object)$contentTypeMappingsForUnmarshalling).hashCode());
        Map<ContentType, MarshallingType<String>> $contentTypeMappingsForMarshalling = this.contentTypeMappingsForMarshalling;
        result = result * 59 + ($contentTypeMappingsForMarshalling == null ? 43 : ((Object)$contentTypeMappingsForMarshalling).hashCode());
        return result;
    }

    @Generated
    private MapMaidMarshallingMapper() {
    }
}

