/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mapmaid;

import de.quantummaid.httpmaid.CoreModule;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.mapmaid.MapMaidConfigurators;
import de.quantummaid.httpmaid.mapmaid.MapMaidMarshallingMapper;
import de.quantummaid.httpmaid.mapmaid.MapMaidValidationExceptionMapper;
import de.quantummaid.httpmaid.mapmaid.advancedscanner.UseCaseClassScanner;
import de.quantummaid.httpmaid.mapmaid.advancedscanner.deserialization_wrappers.MethodParameterDeserializationWrapper;
import de.quantummaid.httpmaid.marshalling.MarshallingModule;
import de.quantummaid.httpmaid.serialization.Serializer;
import de.quantummaid.httpmaid.usecases.UseCasesModule;
import de.quantummaid.httpmaid.usecases.serializing.SerializationAndDeserializationProvider;
import de.quantummaid.httpmaid.usecases.serializing.UseCaseSerializationAndDeserialization;
import de.quantummaid.mapmaid.MapMaid;
import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.mapmaid.mapper.deserialization.validation.AggregatedValidationException;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ReflectMaid;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapMaidModule
implements ChainModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MapMaidModule.class);
    private static final int DEFAULT_VALIDATION_ERROR_STATUS_CODE = 400;
    private final MapMaidMarshallingMapper mapMaidMarshallingMapper = MapMaidMarshallingMapper.mapMaidMarshallingMapper();
    private volatile boolean addAggregatedExceptionHandler = true;
    private volatile int validationErrorStatusCode = 400;

    public static MapMaidModule mapMaidModule() {
        return new MapMaidModule();
    }

    public void doNotAddAggregatedExceptionHandler() {
        this.addAggregatedExceptionHandler = false;
    }

    public void addRequestContentTypeToUnmarshallingTypeMapping(ContentType contentType, MarshallingType<String> marshallingType) {
        this.mapMaidMarshallingMapper.addRequestContentTypeToUnmarshallingTypeMapping(contentType, marshallingType);
    }

    public void addMarshallingTypeToResponseContentTypeMapping(ContentType contentType, MarshallingType<String> marshallingType) {
        this.mapMaidMarshallingMapper.addMarshallingTypeToResponseContentTypeMapping(contentType, marshallingType);
    }

    public void setValidationErrorStatusCode(int validationErrorStatusCode) {
        this.validationErrorStatusCode = validationErrorStatusCode;
    }

    public List<ChainModule> supplyModulesIfNotAlreadyPresent() {
        return Collections.singletonList(MarshallingModule.emptyMarshallingModule());
    }

    public void configure(DependencyRegistry dependencyRegistry) {
        UseCasesModule useCasesModule = (UseCasesModule)dependencyRegistry.getDependency(UseCasesModule.class);
        SerializationAndDeserializationProvider serializationAndDeserializationProvider = (useCaseMethods, injectionTypes, messageTypes) -> {
            ReflectMaid reflectMaid = (ReflectMaid)dependencyRegistry.getMetaDatum(CoreModule.REFLECT_MAID);
            MapMaidBuilder mapMaidBuilder = MapMaid.aMapMaid((ReflectMaid)reflectMaid);
            injectionTypes.forEach(arg_0 -> ((MapMaidBuilder)mapMaidBuilder).injecting(arg_0));
            messageTypes.stream().map(GenericType::fromResolvedType).forEach(arg_0 -> ((MapMaidBuilder)mapMaidBuilder).serializing(arg_0));
            Map<ResolvedType, MethodParameterDeserializationWrapper> deserializationWrappers = UseCaseClassScanner.addAllReferencedClassesIn(useCaseMethods, mapMaidBuilder);
            dependencyRegistry.getMetaData().getOptional(MapMaidConfigurators.RECIPES).ifPresent(recipes -> recipes.forEach(arg_0 -> ((MapMaidBuilder)mapMaidBuilder).usingRecipe(arg_0)));
            MapMaid mapMaid = this.buildMapMaid(mapMaidBuilder);
            HashMap parameterProviders = new HashMap();
            deserializationWrappers.forEach((type, wrapper) -> parameterProviders.put(type, event -> {
                Map map = event.asMap();
                List injections = event.injections();
                List typeInjections = event.typeInjections();
                return wrapper.deserializeParameters(map, injections, typeInjections, mapMaid);
            }));
            MarshallingModule marshallingModule = (MarshallingModule)dependencyRegistry.getDependency(MarshallingModule.class);
            this.mapMaidMarshallingMapper.mapMarshalling(mapMaid, marshallingModule);
            Serializer serializer = (returnValue, type) -> mapMaid.serializeToUniversalObject(returnValue, TypeIdentifier.typeIdentifierFor((ResolvedType)type));
            return UseCaseSerializationAndDeserialization.useCaseSerializationAndDeserialization(parameterProviders, (Serializer)serializer);
        };
        useCasesModule.setSerializationAndDeserializationProvider(serializationAndDeserializationProvider);
        if (this.addAggregatedExceptionHandler) {
            this.addExceptionHandler(dependencyRegistry);
        }
    }

    private void addExceptionHandler(DependencyRegistry dependencyRegistry) {
        CoreModule coreModule = (CoreModule)dependencyRegistry.getDependency(CoreModule.class);
        coreModule.addExceptionMapper(AggregatedValidationException.class::isInstance, MapMaidValidationExceptionMapper.mapMaidValidationExceptionMapper(this.validationErrorStatusCode));
    }

    private MapMaid buildMapMaid(MapMaidBuilder builder) {
        long startTime = System.currentTimeMillis();
        MapMaid mapMaid = builder.build();
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        if (log.isInfoEnabled()) {
            log.info("construction of MapMaid took {}ms", (Object)time);
        }
        return mapMaid;
    }

    public void register(ChainExtender extender) {
    }

    @Generated
    public String toString() {
        return "MapMaidModule(mapMaidMarshallingMapper=" + this.mapMaidMarshallingMapper + ", addAggregatedExceptionHandler=" + this.addAggregatedExceptionHandler + ", validationErrorStatusCode=" + this.validationErrorStatusCode + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapMaidModule)) {
            return false;
        }
        MapMaidModule other = (MapMaidModule)o;
        if (this.addAggregatedExceptionHandler != other.addAggregatedExceptionHandler) {
            return false;
        }
        if (this.validationErrorStatusCode != other.validationErrorStatusCode) {
            return false;
        }
        MapMaidMarshallingMapper this$mapMaidMarshallingMapper = this.mapMaidMarshallingMapper;
        MapMaidMarshallingMapper other$mapMaidMarshallingMapper = other.mapMaidMarshallingMapper;
        return !(this$mapMaidMarshallingMapper == null ? other$mapMaidMarshallingMapper != null : !((Object)this$mapMaidMarshallingMapper).equals(other$mapMaidMarshallingMapper));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.addAggregatedExceptionHandler ? 79 : 97);
        result = result * 59 + this.validationErrorStatusCode;
        MapMaidMarshallingMapper $mapMaidMarshallingMapper = this.mapMaidMarshallingMapper;
        result = result * 59 + ($mapMaidMarshallingMapper == null ? 43 : ((Object)$mapMaidMarshallingMapper).hashCode());
        return result;
    }

    @Generated
    private MapMaidModule() {
    }
}

