/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mapmaid;

import de.quantummaid.httpmaid.CoreModule;
import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.mapmaid.MapMaidConfigurators;
import de.quantummaid.httpmaid.mapmaid.MapMaidMarshallingMapper;
import de.quantummaid.httpmaid.mapmaid.MapMaidSerializerAndDeserializer;
import de.quantummaid.httpmaid.marshalling.MarshallingModule;
import de.quantummaid.httpmaid.usecases.UseCasesModule;
import de.quantummaid.httpmaid.usecases.serializing.SerializerAndDeserializer;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.mapmaid.MapMaid;
import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.mapmaid.builder.recipes.Recipe;
import de.quantummaid.mapmaid.builder.recipes.scanner.ClassScannerRecipe;
import de.quantummaid.mapmaid.mapper.deserialization.validation.AggregatedValidationException;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class MapMaidModule
implements ChainModule {
    private volatile MapMaid mapMaid;
    private final MapMaidMarshallingMapper mapMaidMarshallingMapper = MapMaidMarshallingMapper.mapMaidMarshallingMapper();
    private volatile boolean addAggregatedExceptionHandler = true;

    public static MapMaidModule mapMaidModule() {
        return new MapMaidModule();
    }

    public void setMapMaid(MapMaid mapMaid) {
        Validators.validateNotNull((Object)mapMaid, (String)"mapMaid");
        this.mapMaid = mapMaid;
    }

    public void doNotAddAggregatedExceptionHandler() {
        this.addAggregatedExceptionHandler = false;
    }

    public void addRequestContentTypeToUnmarshallingTypeMapping(ContentType contentType, MarshallingType marshallingType) {
        this.mapMaidMarshallingMapper.addRequestContentTypeToUnmarshallingTypeMapping(contentType, marshallingType);
    }

    public void addMarshallingTypeToResponseContentTypeMapping(ContentType contentType, MarshallingType marshallingType) {
        this.mapMaidMarshallingMapper.addMarshallingTypeToResponseContentTypeMapping(contentType, marshallingType);
    }

    public List<ChainModule> supplyModulesIfNotAlreadyPreset() {
        return Collections.singletonList(MarshallingModule.emptyMarshallingModule());
    }

    public void configure(DependencyRegistry dependencyRegistry) {
        UseCasesModule useCasesModule = (UseCasesModule)dependencyRegistry.getDependency(UseCasesModule.class);
        Set useCases = useCasesModule.getUseCases();
        if (this.mapMaid == null) {
            MapMaidBuilder mapMaidBuilder = MapMaid.aMapMaid((String[])new String[0]);
            ((List)dependencyRegistry.getMetaData().getOrSetDefault(MapMaidConfigurators.RECIPES, LinkedList::new)).forEach(arg_0 -> ((MapMaidBuilder)mapMaidBuilder).usingRecipe(arg_0));
            useCases.forEach(useCase -> mapMaidBuilder.usingRecipe((Recipe)ClassScannerRecipe.addAllReferencedClassesIs((Class[])new Class[]{useCase})));
            this.mapMaid = mapMaidBuilder.build();
        }
        MarshallingModule marshallingModule = (MarshallingModule)dependencyRegistry.getDependency(MarshallingModule.class);
        this.mapMaidMarshallingMapper.mapMarshalling(this.mapMaid, marshallingModule);
        SerializerAndDeserializer serializerAndDeserializer = MapMaidSerializerAndDeserializer.mapMaidSerializerAndDeserializer(this.mapMaid);
        useCasesModule.setSerializerAndDeserializer(serializerAndDeserializer);
        if (this.addAggregatedExceptionHandler) {
            CoreModule coreModule = (CoreModule)dependencyRegistry.getDependency(CoreModule.class);
            coreModule.addExceptionMapper(throwable -> throwable instanceof AggregatedValidationException, (exception, metaData) -> {
                AggregatedValidationException aggregatedException = (AggregatedValidationException)exception;
                List errorsList = aggregatedException.getValidationErrors().stream().map(validationError -> Map.of("message", validationError.message, "path", validationError.propertyPath)).collect(Collectors.toList());
                metaData.set(HttpMaidChainKeys.RESPONSE_BODY_MAP, Map.of("errors", errorsList));
            });
        }
    }

    public void register(ChainExtender extender) {
    }

    public String toString() {
        return "MapMaidModule(mapMaid=" + this.mapMaid + ", mapMaidMarshallingMapper=" + this.mapMaidMarshallingMapper + ", addAggregatedExceptionHandler=" + this.addAggregatedExceptionHandler + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapMaidModule)) {
            return false;
        }
        MapMaidModule other = (MapMaidModule)o;
        MapMaid this$mapMaid = this.mapMaid;
        MapMaid other$mapMaid = other.mapMaid;
        if (this$mapMaid == null ? other$mapMaid != null : !this$mapMaid.equals(other$mapMaid)) {
            return false;
        }
        MapMaidMarshallingMapper this$mapMaidMarshallingMapper = this.mapMaidMarshallingMapper;
        MapMaidMarshallingMapper other$mapMaidMarshallingMapper = other.mapMaidMarshallingMapper;
        if (this$mapMaidMarshallingMapper == null ? other$mapMaidMarshallingMapper != null : !((Object)this$mapMaidMarshallingMapper).equals(other$mapMaidMarshallingMapper)) {
            return false;
        }
        return this.addAggregatedExceptionHandler == other.addAggregatedExceptionHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MapMaid $mapMaid = this.mapMaid;
        result = result * 59 + ($mapMaid == null ? 43 : $mapMaid.hashCode());
        MapMaidMarshallingMapper $mapMaidMarshallingMapper = this.mapMaidMarshallingMapper;
        result = result * 59 + ($mapMaidMarshallingMapper == null ? 43 : ((Object)$mapMaidMarshallingMapper).hashCode());
        result = result * 59 + (this.addAggregatedExceptionHandler ? 79 : 97);
        return result;
    }

    private MapMaidModule() {
    }
}

