/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mapmaid;

import de.quantummaid.httpmaid.CoreModule;
import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.mapmaid.MapMaidConfigurators;
import de.quantummaid.httpmaid.mapmaid.MapMaidMarshallingMapper;
import de.quantummaid.httpmaid.mapmaid.advancedscanner.UseCaseClassScanner;
import de.quantummaid.httpmaid.mapmaid.advancedscanner.deserialization_wrappers.MethodParameterDeserializationWrapper;
import de.quantummaid.httpmaid.marshalling.MarshallingModule;
import de.quantummaid.httpmaid.usecases.UseCasesModule;
import de.quantummaid.httpmaid.usecases.serializing.SerializationAndDeserializationProvider;
import de.quantummaid.httpmaid.usecases.serializing.UseCaseReturnValueSerializer;
import de.quantummaid.httpmaid.usecases.serializing.UseCaseSerializationAndDeserialization;
import de.quantummaid.mapmaid.MapMaid;
import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.mapmaid.mapper.deserialization.validation.AggregatedValidationException;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public final class MapMaidModule
implements ChainModule {
    private final MapMaidMarshallingMapper mapMaidMarshallingMapper = MapMaidMarshallingMapper.mapMaidMarshallingMapper();
    private volatile boolean addAggregatedExceptionHandler = true;

    public static MapMaidModule mapMaidModule() {
        return new MapMaidModule();
    }

    public void doNotAddAggregatedExceptionHandler() {
        this.addAggregatedExceptionHandler = false;
    }

    public void addRequestContentTypeToUnmarshallingTypeMapping(ContentType contentType, MarshallingType marshallingType) {
        this.mapMaidMarshallingMapper.addRequestContentTypeToUnmarshallingTypeMapping(contentType, marshallingType);
    }

    public void addMarshallingTypeToResponseContentTypeMapping(ContentType contentType, MarshallingType marshallingType) {
        this.mapMaidMarshallingMapper.addMarshallingTypeToResponseContentTypeMapping(contentType, marshallingType);
    }

    public List<ChainModule> supplyModulesIfNotAlreadyPresent() {
        return Collections.singletonList(MarshallingModule.emptyMarshallingModule());
    }

    public void configure(DependencyRegistry dependencyRegistry) {
        UseCasesModule useCasesModule = (UseCasesModule)dependencyRegistry.getDependency(UseCasesModule.class);
        SerializationAndDeserializationProvider serializationAndDeserializationProvider = useCaseMethods -> {
            MapMaidBuilder mapMaidBuilder = MapMaid.aMapMaid();
            Map<ResolvedType, MethodParameterDeserializationWrapper> deserializationWrappers = UseCaseClassScanner.addAllReferencedClassesIn(useCaseMethods, mapMaidBuilder);
            dependencyRegistry.getMetaData().getOptional(MapMaidConfigurators.RECIPES).ifPresent(recipes -> recipes.forEach(arg_0 -> ((MapMaidBuilder)mapMaidBuilder).usingRecipe(arg_0)));
            MapMaid mapMaid = mapMaidBuilder.build();
            HashMap parameterProviders = new HashMap();
            deserializationWrappers.forEach((type, wrapper) -> parameterProviders.put(type, event -> {
                Map map = event.asMap();
                List injections = event.injections();
                List typeInjections = event.typeInjections();
                return wrapper.deserializeParameters(map, injections, typeInjections, mapMaid);
            }));
            MarshallingModule marshallingModule = (MarshallingModule)dependencyRegistry.getDependency(MarshallingModule.class);
            this.mapMaidMarshallingMapper.mapMarshalling(mapMaid, marshallingModule);
            UseCaseReturnValueSerializer serializer = (returnValue, type) -> mapMaid.serializer().serializeToUniversalObject(returnValue, TypeIdentifier.typeIdentifierFor((GenericType)GenericType.fromResolvedType((ResolvedType)type)));
            return UseCaseSerializationAndDeserialization.useCaseSerializationAndDeserialization(parameterProviders, (UseCaseReturnValueSerializer)serializer);
        };
        useCasesModule.setSerializationAndDeserializationProvider(serializationAndDeserializationProvider);
        if (this.addAggregatedExceptionHandler) {
            MapMaidModule.addExceptionHandler(dependencyRegistry);
        }
    }

    private static void addExceptionHandler(DependencyRegistry dependencyRegistry) {
        CoreModule coreModule = (CoreModule)dependencyRegistry.getDependency(CoreModule.class);
        coreModule.addExceptionMapper(throwable -> throwable instanceof AggregatedValidationException, (exception, metaData) -> {
            AggregatedValidationException aggregatedException = (AggregatedValidationException)exception;
            List errorsList = aggregatedException.getValidationErrors().stream().map(validationError -> Map.of("message", validationError.message, "path", validationError.propertyPath)).collect(Collectors.toList());
            metaData.set(HttpMaidChainKeys.RESPONSE_BODY_OBJECT, Map.of("errors", errorsList));
        });
    }

    public void register(ChainExtender extender) {
    }

    @Generated
    public String toString() {
        return "MapMaidModule(mapMaidMarshallingMapper=" + this.mapMaidMarshallingMapper + ", addAggregatedExceptionHandler=" + this.addAggregatedExceptionHandler + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapMaidModule)) {
            return false;
        }
        MapMaidModule other = (MapMaidModule)o;
        MapMaidMarshallingMapper this$mapMaidMarshallingMapper = this.mapMaidMarshallingMapper;
        MapMaidMarshallingMapper other$mapMaidMarshallingMapper = other.mapMaidMarshallingMapper;
        if (this$mapMaidMarshallingMapper == null ? other$mapMaidMarshallingMapper != null : !((Object)this$mapMaidMarshallingMapper).equals(other$mapMaidMarshallingMapper)) {
            return false;
        }
        return this.addAggregatedExceptionHandler == other.addAggregatedExceptionHandler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MapMaidMarshallingMapper $mapMaidMarshallingMapper = this.mapMaidMarshallingMapper;
        result = result * 59 + ($mapMaidMarshallingMapper == null ? 43 : ((Object)$mapMaidMarshallingMapper).hashCode());
        result = result * 59 + (this.addAggregatedExceptionHandler ? 79 : 97);
        return result;
    }

    @Generated
    private MapMaidModule() {
    }
}

