/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mapmaid;

import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.mapmaid.MapMaidModule;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.mapmaid.builder.recipes.Recipe;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class MapMaidConfigurators {
    public static final MetaDataKey<List<Recipe>> RECIPES = MetaDataKey.metaDataKey((String)"RECIPES");

    private MapMaidConfigurators() {
    }

    public static Configurator toSetStatusCodeOnMapMaidValidationErrorsTo(int statusCode) {
        return Configurator.configuratorForType(MapMaidModule.class, mapMaidModule -> mapMaidModule.setValidationErrorStatusCode(statusCode));
    }

    public static Configurator toNotCreateAnAutomaticResponseForMapMaidValidationErrors() {
        return Configurator.configuratorForType(MapMaidModule.class, MapMaidModule::doNotAddAggregatedExceptionHandler);
    }

    public static Configurator toConfigureMapMaidUsingRecipe(final Recipe recipe) {
        Validators.validateNotNull((Object)recipe, (String)"recipe");
        return new Configurator(){

            public List<ChainModule> supplyModulesIfNotAlreadyPresent() {
                return Collections.singletonList(MapMaidModule.mapMaidModule());
            }

            public void init(MetaData configurationMetaData) {
                ((List)configurationMetaData.getOrSetDefault(RECIPES, LinkedList::new)).add(recipe);
            }

            public void configure(DependencyRegistry dependencyRegistry) {
            }
        };
    }
}

