/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mapmaid;

import de.quantummaid.httpmaid.exceptions.HttpExceptionMapper;
import de.quantummaid.httpmaid.handler.http.HttpResponse;
import de.quantummaid.mapmaid.mapper.deserialization.validation.AggregatedValidationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public final class MapMaidValidationExceptionMapper
implements HttpExceptionMapper<Throwable> {
    private final int statusCode;

    public static HttpExceptionMapper<Throwable> mapMaidValidationExceptionMapper(int statusCode) {
        return new MapMaidValidationExceptionMapper(statusCode);
    }

    public void map(Throwable exception, HttpResponse response) {
        if (!(exception instanceof AggregatedValidationException)) {
            throw new UnsupportedOperationException(String.format("%s can only be registered for %s but got %s. This should never happen.", MapMaidValidationExceptionMapper.class.getSimpleName(), AggregatedValidationException.class.getSimpleName(), exception));
        }
        AggregatedValidationException aggregatedException = (AggregatedValidationException)exception;
        List errorsList = aggregatedException.getValidationErrors().stream().map(validationError -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("path", validationError.propertyPath);
            if (validationError.message != null) {
                map.put("message", validationError.message);
            }
            return map;
        }).collect(Collectors.toList());
        response.setBody(Map.of("errors", errorsList));
        response.setStatus(this.statusCode);
    }

    @Generated
    public String toString() {
        return "MapMaidValidationExceptionMapper(statusCode=" + this.statusCode + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapMaidValidationExceptionMapper)) {
            return false;
        }
        MapMaidValidationExceptionMapper other = (MapMaidValidationExceptionMapper)o;
        return this.statusCode == other.statusCode;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.statusCode;
        return result;
    }

    @Generated
    private MapMaidValidationExceptionMapper(int statusCode) {
        this.statusCode = statusCode;
    }
}

