/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.servletwithwebsockets;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.servlet.ServletHandling;
import de.quantummaid.httpmaid.servletwithwebsockets.JettyStyleWebSocket;
import de.quantummaid.httpmaid.websockets.WebsocketChainKeys;
import de.quantummaid.httpmaid.websockets.registry.WebSocketId;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public final class WebSocketAwareHttpMaidServlet
extends WebSocketServlet {
    private static final long serialVersionUID = 1L;
    private final transient HttpMaid httpMaid;

    public static WebSocketAwareHttpMaidServlet webSocketAwareHttpMaidServlet(HttpMaid httpMaid) {
        return new WebSocketAwareHttpMaidServlet(httpMaid);
    }

    public void configure(WebSocketServletFactory webSocketServletFactory) {
        webSocketServletFactory.setCreator((servletUpgradeRequest, servletUpgradeResponse) -> {
            MetaData metaData = ServletHandling.extractMetaDataFromHttpServletRequest((HttpServletRequest)servletUpgradeRequest.getHttpServletRequest());
            WebSocketId webSocketId = WebSocketId.randomWebSocketId();
            metaData.set(WebsocketChainKeys.WEBSOCKET_ID, (Object)webSocketId);
            JettyStyleWebSocket jettyStyleSocket = JettyStyleWebSocket.jettyStyleSocket(this.httpMaid, webSocketId);
            metaData.set(WebsocketChainKeys.WEBSOCKET_DELEGATE, (Object)jettyStyleSocket);
            this.httpMaid.handleRequest(metaData, m -> {});
            if (metaData.getOptional(WebsocketChainKeys.WEBSOCKET_ACCEPTED).orElse(false).booleanValue()) {
                return jettyStyleSocket;
            }
            return null;
        });
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletHandling.handle((HttpMaid)this.httpMaid, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletHandling.handle((HttpMaid)this.httpMaid, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletHandling.handle((HttpMaid)this.httpMaid, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletHandling.handle((HttpMaid)this.httpMaid, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletHandling.handle((HttpMaid)this.httpMaid, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    @Generated
    public String toString() {
        return "WebSocketAwareHttpMaidServlet(httpMaid=" + this.httpMaid + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebSocketAwareHttpMaidServlet)) {
            return false;
        }
        WebSocketAwareHttpMaidServlet other = (WebSocketAwareHttpMaidServlet)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WebSocketAwareHttpMaidServlet;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    private WebSocketAwareHttpMaidServlet(HttpMaid httpMaid) {
        this.httpMaid = httpMaid;
    }
}

