/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.servletwithwebsockets;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.util.Streams;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebSocketDelegate;
import de.quantummaid.httpmaid.websockets.WebsocketChainKeys;
import de.quantummaid.httpmaid.websockets.WebsocketChains;
import de.quantummaid.httpmaid.websockets.registry.WebSocketId;
import java.io.IOException;
import lombok.Generated;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;

public final class JettyStyleWebSocket
implements WebSocketListener,
WebSocketDelegate {
    private final HttpMaid httpMaid;
    private final WebSocketId id;
    private Session session;

    static JettyStyleWebSocket jettyStyleSocket(HttpMaid httpMaid, WebSocketId webSocketId) {
        Validators.validateNotNull((Object)httpMaid, (String)"httpMaid");
        Validators.validateNotNull((Object)webSocketId, (String)"webSocketId");
        return new JettyStyleWebSocket(httpMaid, webSocketId);
    }

    public void sendText(String text) {
        RemoteEndpoint remote = this.session.getRemote();
        try {
            remote.sendString(text);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.session.close();
    }

    public void onWebSocketBinary(byte[] bytes, int i, int i1) {
        throw new UnsupportedOperationException();
    }

    public void onWebSocketText(String text) {
        MetaData metaData = MetaData.emptyMetaData();
        metaData.set(WebsocketChainKeys.WEBSOCKET_ID, (Object)this.id);
        metaData.set(HttpMaidChainKeys.REQUEST_BODY_STREAM, (Object)Streams.stringToInputStream((String)text));
        metaData.set(WebsocketChainKeys.IS_WEBSOCKET_MESSAGE, (Object)true);
        this.httpMaid.handleRequest(metaData, m -> {});
    }

    public void onWebSocketClose(int i, String s) {
        MetaData metaData = MetaData.emptyMetaData();
        metaData.set(WebsocketChainKeys.WEBSOCKET_ID, (Object)this.id);
        this.httpMaid.handle(WebsocketChains.WEBSOCKET_CLOSED, metaData);
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
        MetaData metaData = MetaData.emptyMetaData();
        metaData.set(WebsocketChainKeys.WEBSOCKET_ID, (Object)this.id);
        this.httpMaid.handle(WebsocketChains.WEBSOCKET_OPEN, metaData);
    }

    public void onWebSocketError(Throwable throwable) {
    }

    @Generated
    private JettyStyleWebSocket(HttpMaid httpMaid, WebSocketId id) {
        this.httpMaid = httpMaid;
        this.id = id;
    }
}

