/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.undertow;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketMessage;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.sender.NonSerializableConnectionInformation;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import lombok.Generated;

public final class ReceiveListener
extends AbstractReceiveListener {
    private final NonSerializableConnectionInformation connectionInformation;
    private final HttpMaid httpMaid;

    public static ReceiveListener receiveListener(NonSerializableConnectionInformation connectionInformation, HttpMaid httpMaid) {
        return new ReceiveListener(connectionInformation, httpMaid);
    }

    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) {
        this.httpMaid.handleRequest(() -> {
            String messageData = message.getData();
            return RawWebsocketMessage.rawWebsocketMessage((ConnectionInformation)this.connectionInformation, (String)messageData);
        }, response -> response.optionalStringBody().ifPresent(responseMessage -> WebSockets.sendText((String)responseMessage, (WebSocketChannel)channel, null)));
    }

    @Generated
    public String toString() {
        return "ReceiveListener(connectionInformation=" + this.connectionInformation + ", httpMaid=" + this.httpMaid + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReceiveListener)) {
            return false;
        }
        ReceiveListener other = (ReceiveListener)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NonSerializableConnectionInformation this$connectionInformation = this.connectionInformation;
        NonSerializableConnectionInformation other$connectionInformation = other.connectionInformation;
        if (this$connectionInformation == null ? other$connectionInformation != null : !this$connectionInformation.equals(other$connectionInformation)) {
            return false;
        }
        HttpMaid this$httpMaid = this.httpMaid;
        HttpMaid other$httpMaid = other.httpMaid;
        return !(this$httpMaid == null ? other$httpMaid != null : !this$httpMaid.equals(other$httpMaid));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReceiveListener;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        NonSerializableConnectionInformation $connectionInformation = this.connectionInformation;
        result = result * 59 + ($connectionInformation == null ? 43 : $connectionInformation.hashCode());
        HttpMaid $httpMaid = this.httpMaid;
        result = result * 59 + ($httpMaid == null ? 43 : $httpMaid.hashCode());
        return result;
    }

    @Generated
    private ReceiveListener(NonSerializableConnectionInformation connectionInformation, HttpMaid httpMaid) {
        this.connectionInformation = connectionInformation;
        this.httpMaid = httpMaid;
    }
}

