/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.undertow;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.http.HeadersBuilder;
import de.quantummaid.httpmaid.undertow.CloseListener;
import de.quantummaid.httpmaid.undertow.ReceiveListener;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketConnect;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketConnectBuilder;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.sender.NonSerializableConnectionInformation;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.util.Map;
import lombok.Generated;
import org.xnio.ChannelListener;

public final class UndertowWebsocketsCallback
implements WebSocketConnectionCallback {
    private final HttpMaid httpMaid;

    public static UndertowWebsocketsCallback undertowWebsocketsCallback(HttpMaid httpMaid) {
        return new UndertowWebsocketsCallback(httpMaid);
    }

    public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
        NonSerializableConnectionInformation connectionInformation = message -> WebSockets.sendText((String)message, (WebSocketChannel)channel, null);
        this.httpMaid.handleRequest(() -> {
            RawWebsocketConnectBuilder builder = RawWebsocketConnect.rawWebsocketConnectBuilder();
            builder.withNonSerializableConnectionInformation(connectionInformation);
            builder.withEncodedQueryString(exchange.getQueryString());
            Map requestHeaders = exchange.getRequestHeaders();
            HeadersBuilder headersBuilder = HeadersBuilder.headersBuilder();
            headersBuilder.withHeadersMap(requestHeaders);
            builder.withHeaders(headersBuilder.build());
            return builder.build();
        }, response -> {});
        channel.getCloseSetter().set(CloseListener.closeListener((ConnectionInformation)connectionInformation, this.httpMaid));
        channel.getReceiveSetter().set((ChannelListener)ReceiveListener.receiveListener(connectionInformation, this.httpMaid));
        channel.resumeReceives();
    }

    @Generated
    public String toString() {
        return "UndertowWebsocketsCallback(httpMaid=" + this.httpMaid + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UndertowWebsocketsCallback)) {
            return false;
        }
        UndertowWebsocketsCallback other = (UndertowWebsocketsCallback)o;
        HttpMaid this$httpMaid = this.httpMaid;
        HttpMaid other$httpMaid = other.httpMaid;
        return !(this$httpMaid == null ? other$httpMaid != null : !this$httpMaid.equals(other$httpMaid));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpMaid $httpMaid = this.httpMaid;
        result = result * 59 + ($httpMaid == null ? 43 : $httpMaid.hashCode());
        return result;
    }

    @Generated
    private UndertowWebsocketsCallback(HttpMaid httpMaid) {
        this.httpMaid = httpMaid;
    }
}

