/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.undertow;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.endpoint.RawHttpRequest;
import de.quantummaid.httpmaid.endpoint.RawHttpRequestBuilder;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.HeadersBuilder;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import lombok.Generated;

public final class UndertowHandler
implements HttpHandler {
    private final HttpMaid httpMaid;

    public static UndertowHandler undertowHandler(HttpMaid httpMaid) {
        return new UndertowHandler(httpMaid);
    }

    public void handleRequest(HttpServerExchange httpServerExchange) {
        if (httpServerExchange.isInIoThread()) {
            httpServerExchange.dispatch((HttpHandler)this);
            return;
        }
        this.httpMaid.handleRequest(() -> {
            RawHttpRequestBuilder builder = RawHttpRequest.rawHttpRequestBuilder();
            Headers headers = UndertowHandler.extractHeaders(httpServerExchange);
            builder.withHeaders(headers);
            String path = httpServerExchange.getRequestPath();
            builder.withPath(path);
            HttpString requestMethod = httpServerExchange.getRequestMethod();
            builder.withMethod(requestMethod.toString());
            String queryString = httpServerExchange.getQueryString();
            builder.withQueryString(queryString);
            httpServerExchange.startBlocking();
            InputStream body = httpServerExchange.getInputStream();
            builder.withBody(body);
            return builder.build();
        }, response -> {
            int status = response.status();
            httpServerExchange.setStatusCode(status);
            HeaderMap responseHeaders = httpServerExchange.getResponseHeaders();
            response.headers().forEach((name, values) -> responseHeaders.putAll(HttpString.tryFromString((String)name), (Collection)values));
            OutputStream outputStream = httpServerExchange.getOutputStream();
            response.streamBodyToOutputStream(outputStream);
        });
    }

    private static Headers extractHeaders(HttpServerExchange httpServerExchange) {
        HeadersBuilder headersBuilder = HeadersBuilder.headersBuilder();
        HeaderMap requestHeaders = httpServerExchange.getRequestHeaders();
        requestHeaders.forEach(header -> {
            String name = header.getHeaderName().toString();
            headersBuilder.withAdditionalHeader(name, (List)header);
        });
        return headersBuilder.build();
    }

    @Generated
    public String toString() {
        return "UndertowHandler(httpMaid=" + this.httpMaid + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UndertowHandler)) {
            return false;
        }
        UndertowHandler other = (UndertowHandler)o;
        HttpMaid this$httpMaid = this.httpMaid;
        HttpMaid other$httpMaid = other.httpMaid;
        return !(this$httpMaid == null ? other$httpMaid != null : !this$httpMaid.equals(other$httpMaid));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpMaid $httpMaid = this.httpMaid;
        result = result * 59 + ($httpMaid == null ? 43 : $httpMaid.hashCode());
        return result;
    }

    @Generated
    private UndertowHandler(HttpMaid httpMaid) {
        this.httpMaid = httpMaid;
    }
}

