/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.MetaDataEntry;
import de.quantummaid.httpmaid.websockets.MetaDataEntryProvider;
import de.quantummaid.httpmaid.websockets.SavedMetaDataEntries;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public final class MetaDataEntriesToSave {
    private final List<MetaDataEntryProvider<?>> entryProviders;

    public static MetaDataEntriesToSave metaDataEntriesToSave(List<MetaDataEntryProvider<?>> entryProviders) {
        Validators.validateNotNull(entryProviders, (String)"entryProviders");
        LinkedList realProviders = new LinkedList(entryProviders);
        Collections.addAll(realProviders, MetaDataEntryProvider.saving(HttpMaidChainKeys.PATH), MetaDataEntryProvider.saving(HttpMaidChainKeys.PATH_PARAMETERS), MetaDataEntryProvider.saving(HttpMaidChainKeys.QUERY_PARAMETERS), MetaDataEntryProvider.saving(HttpMaidChainKeys.REQUEST_HEADERS), MetaDataEntryProvider.saving(HttpMaidChainKeys.REQUEST_CONTENT_TYPE));
        return new MetaDataEntriesToSave(realProviders);
    }

    public SavedMetaDataEntries save(MetaData metaData) {
        Validators.validateNotNull((Object)metaData, (String)"metaData");
        HashMap savedMetaData = new HashMap();
        this.entryProviders.forEach(entryProvider -> {
            MetaDataEntry entry = entryProvider.provide(metaData);
            savedMetaData.put(entry.key(), entry.value());
        });
        return SavedMetaDataEntries.savedMetaDataEntries(savedMetaData);
    }

    public String toString() {
        return "MetaDataEntriesToSave(entryProviders=" + this.entryProviders + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaDataEntriesToSave)) {
            return false;
        }
        MetaDataEntriesToSave other = (MetaDataEntriesToSave)o;
        List<MetaDataEntryProvider<?>> this$entryProviders = this.entryProviders;
        List<MetaDataEntryProvider<?>> other$entryProviders = other.entryProviders;
        return !(this$entryProviders == null ? other$entryProviders != null : !((Object)this$entryProviders).equals(other$entryProviders));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<MetaDataEntryProvider<?>> $entryProviders = this.entryProviders;
        result = result * 59 + ($entryProviders == null ? 43 : ((Object)$entryProviders).hashCode());
        return result;
    }

    private MetaDataEntriesToSave(List<MetaDataEntryProvider<?>> entryProviders) {
        this.entryProviders = entryProviders;
    }
}

