/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.processors;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebSocket;
import de.quantummaid.httpmaid.websockets.WebsocketChainKeys;
import de.quantummaid.httpmaid.websockets.registry.WebSocketId;
import de.quantummaid.httpmaid.websockets.registry.WebSocketRegistry;

public final class HandleNewWebSocketMessageProcessor
implements Processor {
    private final WebSocketRegistry registry;

    public static Processor handleNewWebSocketMessageProcessor(WebSocketRegistry registry) {
        Validators.validateNotNull((Object)registry, (String)"registry");
        return new HandleNewWebSocketMessageProcessor(registry);
    }

    public void apply(MetaData metaData) {
        metaData.set(WebsocketChainKeys.IS_WEBSOCKET, (Object)true);
        WebSocketId webSocketId = (WebSocketId)metaData.get(WebsocketChainKeys.WEBSOCKET_ID);
        WebSocket webSocket = this.registry.byId(webSocketId);
        webSocket.savedMetaDataEntries().restoreTo(metaData);
    }

    public String toString() {
        return "HandleNewWebSocketMessageProcessor(registry=" + this.registry + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HandleNewWebSocketMessageProcessor)) {
            return false;
        }
        HandleNewWebSocketMessageProcessor other = (HandleNewWebSocketMessageProcessor)o;
        WebSocketRegistry this$registry = this.registry;
        WebSocketRegistry other$registry = other.registry;
        return !(this$registry == null ? other$registry != null : !((Object)this$registry).equals(other$registry));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebSocketRegistry $registry = this.registry;
        result = result * 59 + ($registry == null ? 43 : ((Object)$registry).hashCode());
        return result;
    }

    private HandleNewWebSocketMessageProcessor(WebSocketRegistry registry) {
        this.registry = registry;
    }
}

