/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.processors;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.MetaDataEntriesToSave;
import de.quantummaid.httpmaid.websockets.SavedMetaDataEntries;
import de.quantummaid.httpmaid.websockets.WebSocket;
import de.quantummaid.httpmaid.websockets.WebSocketDelegate;
import de.quantummaid.httpmaid.websockets.WebSocketMapping;
import de.quantummaid.httpmaid.websockets.WebsocketChainKeys;
import de.quantummaid.httpmaid.websockets.registry.WebSocketId;
import de.quantummaid.httpmaid.websockets.registry.WebSocketRegistry;

public final class CreateWebSocketProcessor
implements Processor {
    private final WebSocketRegistry webSocketRegistry;

    public static Processor createWebSocketProcessor(WebSocketRegistry webSocketRegistry) {
        Validators.validateNotNull((Object)webSocketRegistry, (String)"webSocketRegistry");
        return new CreateWebSocketProcessor(webSocketRegistry);
    }

    public void apply(MetaData metaData) {
        metaData.getOptional(WebsocketChainKeys.WEBSOCKET_MAPPING).ifPresent(webSocketMapping -> this.createWebSocket((WebSocketMapping)webSocketMapping, metaData));
    }

    private void createWebSocket(WebSocketMapping webSocketMapping, MetaData metaData) {
        MetaDataEntriesToSave metaDataEntriesToSave = webSocketMapping.metaDataEntriesToSave();
        SavedMetaDataEntries savedMetaDataEntries = metaDataEntriesToSave.save(metaData);
        WebSocketId id = (WebSocketId)metaData.get(WebsocketChainKeys.WEBSOCKET_ID);
        WebSocketDelegate webSocketDelegate = (WebSocketDelegate)metaData.get(WebsocketChainKeys.WEBSOCKET_DELEGATE);
        WebSocket webSocket = WebSocket.webSocket(id, webSocketDelegate, savedMetaDataEntries);
        this.webSocketRegistry.register(id, webSocket);
        metaData.set(WebsocketChainKeys.WEBSOCKET_ACCEPTED, (Object)true);
    }

    public String toString() {
        return "CreateWebSocketProcessor(webSocketRegistry=" + this.webSocketRegistry + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateWebSocketProcessor)) {
            return false;
        }
        CreateWebSocketProcessor other = (CreateWebSocketProcessor)o;
        WebSocketRegistry this$webSocketRegistry = this.webSocketRegistry;
        WebSocketRegistry other$webSocketRegistry = other.webSocketRegistry;
        return !(this$webSocketRegistry == null ? other$webSocketRegistry != null : !((Object)this$webSocketRegistry).equals(other$webSocketRegistry));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebSocketRegistry $webSocketRegistry = this.webSocketRegistry;
        result = result * 59 + ($webSocketRegistry == null ? 43 : ((Object)$webSocketRegistry).hashCode());
        return result;
    }

    private CreateWebSocketProcessor(WebSocketRegistry webSocketRegistry) {
        this.webSocketRegistry = webSocketRegistry;
    }
}

