/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets;

import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.SavedMetaDataEntries;
import de.quantummaid.httpmaid.websockets.WebSocketDelegate;
import de.quantummaid.httpmaid.websockets.registry.WebSocketId;
import lombok.Generated;

public final class WebSocket {
    private final WebSocketId id;
    private final WebSocketDelegate webSocketDelegate;
    private final SavedMetaDataEntries savedMetaDataEntries;

    public static WebSocket webSocket(WebSocketId id, WebSocketDelegate webSocketDelegate, SavedMetaDataEntries savedMetaDataEntries) {
        Validators.validateNotNull((Object)id, (String)"id");
        Validators.validateNotNull((Object)savedMetaDataEntries, (String)"savedMetaDataEntries");
        return new WebSocket(id, webSocketDelegate, savedMetaDataEntries);
    }

    public WebSocketId id() {
        return this.id;
    }

    public SavedMetaDataEntries savedMetaDataEntries() {
        return this.savedMetaDataEntries;
    }

    public synchronized void sendText(String message) {
        this.webSocketDelegate.sendText(message);
    }

    public synchronized void close() {
        this.webSocketDelegate.close();
    }

    public String toString() {
        return "Websocket(" + this.id.id() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebSocket)) {
            return false;
        }
        WebSocket other = (WebSocket)o;
        WebSocketId this$id = this.id;
        WebSocketId other$id = other.id;
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        WebSocketDelegate this$webSocketDelegate = this.webSocketDelegate;
        WebSocketDelegate other$webSocketDelegate = other.webSocketDelegate;
        if (this$webSocketDelegate == null ? other$webSocketDelegate != null : !this$webSocketDelegate.equals(other$webSocketDelegate)) {
            return false;
        }
        SavedMetaDataEntries this$savedMetaDataEntries = this.savedMetaDataEntries;
        SavedMetaDataEntries other$savedMetaDataEntries = other.savedMetaDataEntries;
        return !(this$savedMetaDataEntries == null ? other$savedMetaDataEntries != null : !((Object)this$savedMetaDataEntries).equals(other$savedMetaDataEntries));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebSocketId $id = this.id;
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        WebSocketDelegate $webSocketDelegate = this.webSocketDelegate;
        result = result * 59 + ($webSocketDelegate == null ? 43 : $webSocketDelegate.hashCode());
        SavedMetaDataEntries $savedMetaDataEntries = this.savedMetaDataEntries;
        result = result * 59 + ($savedMetaDataEntries == null ? 43 : ((Object)$savedMetaDataEntries).hashCode());
        return result;
    }

    @Generated
    private WebSocket(WebSocketId id, WebSocketDelegate webSocketDelegate, SavedMetaDataEntries savedMetaDataEntries) {
        this.id = id;
        this.webSocketDelegate = webSocketDelegate;
        this.savedMetaDataEntries = savedMetaDataEntries;
    }
}

