/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.processors;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketChainKeys;
import de.quantummaid.httpmaid.websockets.registry.WebSocketRegistry;
import java.util.List;
import lombok.Generated;

public final class CloseWebSocketProcessor
implements Processor {
    private final WebSocketRegistry registry;

    public static Processor closeWebSocketProcessor(WebSocketRegistry registry) {
        Validators.validateNotNull((Object)registry, (String)"registry");
        return new CloseWebSocketProcessor(registry);
    }

    public void apply(MetaData metaData) {
        List webSockets = (List)metaData.get(WebsocketChainKeys.WEBSOCKETS_TO_CLOSE);
        webSockets.forEach(webSocket -> {
            this.registry.unregister(webSocket.id());
            webSocket.close();
        });
    }

    @Generated
    public String toString() {
        return "CloseWebSocketProcessor(registry=" + this.registry + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloseWebSocketProcessor)) {
            return false;
        }
        CloseWebSocketProcessor other = (CloseWebSocketProcessor)o;
        WebSocketRegistry this$registry = this.registry;
        WebSocketRegistry other$registry = other.registry;
        return !(this$registry == null ? other$registry != null : !((Object)this$registry).equals(other$registry));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebSocketRegistry $registry = this.registry;
        result = result * 59 + ($registry == null ? 43 : ((Object)$registry).hashCode());
        return result;
    }

    @Generated
    private CloseWebSocketProcessor(WebSocketRegistry registry) {
        this.registry = registry;
    }
}

