/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets;

import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.path.PathTemplate;
import de.quantummaid.httpmaid.websockets.MetaDataEntriesToSave;
import de.quantummaid.httpmaid.websockets.MetaDataEntryProvider;
import de.quantummaid.httpmaid.websockets.WebSocketMapping;
import de.quantummaid.httpmaid.websockets.WebSocketModule;
import de.quantummaid.httpmaid.websockets.builder.CategorizerStage;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;

public final class WebSocketsConfigurator
implements Configurator {
    private final List<WebSocketMapping> webSocketMappings = new LinkedList<WebSocketMapping>();

    public static WebSocketsConfigurator toUseWebSockets() {
        return new WebSocketsConfigurator();
    }

    public CategorizerStage acceptingWebSocketsToThePath(final String template) {
        return new CategorizerStage(){

            @Override
            public <T> WebSocketsConfigurator initializingMetaDataForIncomingMessagesWith(MetaDataKey<T> key, Function<MetaData, T> valueProvider) {
                MetaDataEntryProvider<T> provider = MetaDataEntryProvider.storing(key, valueProvider);
                MetaDataEntriesToSave metaDataEntriesToSave = MetaDataEntriesToSave.metaDataEntriesToSave(Collections.singletonList(provider));
                WebSocketMapping webSocketMapping = WebSocketMapping.webSocketMapping(metaDataEntriesToSave, PathTemplate.pathTemplate((String)template));
                WebSocketsConfigurator.this.webSocketMappings.add(webSocketMapping);
                return WebSocketsConfigurator.this;
            }
        };
    }

    public List<ChainModule> supplyModulesIfNotAlreadyPresent() {
        return Arrays.asList(WebSocketModule.webSocketModule());
    }

    public void configure(DependencyRegistry dependencyRegistry) {
        WebSocketModule webSocketModule = (WebSocketModule)dependencyRegistry.getDependency(WebSocketModule.class);
        this.webSocketMappings.forEach(webSocketModule::addWebSocketMapping);
    }

    @Generated
    public String toString() {
        return "WebSocketsConfigurator(webSocketMappings=" + this.webSocketMappings + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebSocketsConfigurator)) {
            return false;
        }
        WebSocketsConfigurator other = (WebSocketsConfigurator)o;
        List<WebSocketMapping> this$webSocketMappings = this.webSocketMappings;
        List<WebSocketMapping> other$webSocketMappings = other.webSocketMappings;
        return !(this$webSocketMappings == null ? other$webSocketMappings != null : !((Object)this$webSocketMappings).equals(other$webSocketMappings));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<WebSocketMapping> $webSocketMappings = this.webSocketMappings;
        result = result * 59 + ($webSocketMappings == null ? 43 : ((Object)$webSocketMappings).hashCode());
        return result;
    }

    @Generated
    private WebSocketsConfigurator() {
    }
}

