/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.registry;

import de.quantummaid.httpmaid.MetricsProvider;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebSocket;
import de.quantummaid.httpmaid.websockets.registry.SaveMap;
import de.quantummaid.httpmaid.websockets.registry.WebSocketId;
import de.quantummaid.httpmaid.websockets.registry.WebSocketNotFoundException;
import java.util.Set;
import lombok.Generated;

public final class WebSocketRegistry {
    private final SaveMap<WebSocketId, WebSocket> preActiveWebSockets;
    private final SaveMap<WebSocketId, WebSocket> activeWebSockets;
    private final MetricsProvider<Integer> metricsProvider;

    public static WebSocketRegistry webSocketRegistry(MetricsProvider<Integer> metricsProvider) {
        Validators.validateNotNull(metricsProvider, (String)"metricsProvider");
        return new WebSocketRegistry(SaveMap.saveMap(), SaveMap.saveMap(), metricsProvider);
    }

    public synchronized WebSocket byId(WebSocketId id) {
        return this.activeWebSockets.get(id).orElseThrow(() -> WebSocketNotFoundException.webSocketNotFoundException(id));
    }

    public synchronized void register(WebSocketId id, WebSocket webSocket) {
        this.preActiveWebSockets.put(id, webSocket);
        this.updateMetrics();
    }

    public synchronized void activate(WebSocketId id) {
        WebSocket webSocket = this.preActiveWebSockets.getAndRemove(id).orElseThrow(() -> WebSocketNotFoundException.webSocketNotFoundException(id));
        this.activeWebSockets.put(id, webSocket);
    }

    public synchronized void unregister(WebSocketId id) {
        this.activeWebSockets.remove(id, () -> WebSocketNotFoundException.webSocketNotFoundException(id));
        this.updateMetrics();
    }

    public synchronized Set<WebSocket> allActiveWebSockets() {
        return this.activeWebSockets.copyOfValues();
    }

    private void updateMetrics() {
        this.metricsProvider.provideMetric((Object)(this.activeWebSockets.size() + this.preActiveWebSockets.size()));
    }

    public String toString() {
        return "WebSocketRegistry";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebSocketRegistry)) {
            return false;
        }
        WebSocketRegistry other = (WebSocketRegistry)o;
        SaveMap<WebSocketId, WebSocket> this$preActiveWebSockets = this.preActiveWebSockets;
        SaveMap<WebSocketId, WebSocket> other$preActiveWebSockets = other.preActiveWebSockets;
        if (this$preActiveWebSockets == null ? other$preActiveWebSockets != null : !((Object)this$preActiveWebSockets).equals(other$preActiveWebSockets)) {
            return false;
        }
        SaveMap<WebSocketId, WebSocket> this$activeWebSockets = this.activeWebSockets;
        SaveMap<WebSocketId, WebSocket> other$activeWebSockets = other.activeWebSockets;
        if (this$activeWebSockets == null ? other$activeWebSockets != null : !((Object)this$activeWebSockets).equals(other$activeWebSockets)) {
            return false;
        }
        MetricsProvider<Integer> this$metricsProvider = this.metricsProvider;
        MetricsProvider<Integer> other$metricsProvider = other.metricsProvider;
        return !(this$metricsProvider == null ? other$metricsProvider != null : !this$metricsProvider.equals(other$metricsProvider));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SaveMap<WebSocketId, WebSocket> $preActiveWebSockets = this.preActiveWebSockets;
        result = result * 59 + ($preActiveWebSockets == null ? 43 : ((Object)$preActiveWebSockets).hashCode());
        SaveMap<WebSocketId, WebSocket> $activeWebSockets = this.activeWebSockets;
        result = result * 59 + ($activeWebSockets == null ? 43 : ((Object)$activeWebSockets).hashCode());
        MetricsProvider<Integer> $metricsProvider = this.metricsProvider;
        result = result * 59 + ($metricsProvider == null ? 43 : $metricsProvider.hashCode());
        return result;
    }

    @Generated
    private WebSocketRegistry(SaveMap<WebSocketId, WebSocket> preActiveWebSockets, SaveMap<WebSocketId, WebSocket> activeWebSockets, MetricsProvider<Integer> metricsProvider) {
        this.preActiveWebSockets = preActiveWebSockets;
        this.activeWebSockets = activeWebSockets;
        this.metricsProvider = metricsProvider;
    }
}

