/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.processors;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebSocket;
import de.quantummaid.httpmaid.websockets.WebsocketChainKeys;
import de.quantummaid.httpmaid.websockets.registry.WebSocketId;
import de.quantummaid.httpmaid.websockets.registry.WebSocketRegistry;
import java.util.Collections;
import lombok.Generated;

public final class WebSocketInitializationProcessor
implements Processor {
    private final WebSocketRegistry registry;

    public static Processor webSocketInitializationProcessor(WebSocketRegistry registry) {
        Validators.validateNotNull((Object)registry, (String)"registry");
        return new WebSocketInitializationProcessor(registry);
    }

    public void apply(MetaData metaData) {
        metaData.set(WebsocketChainKeys.WEBSOCKET_REGISTRY, (Object)this.registry);
        if (metaData.getOptional(WebsocketChainKeys.IS_WEBSOCKET_MESSAGE).orElse(false).booleanValue()) {
            metaData.getOptional(WebsocketChainKeys.WEBSOCKET_ID).ifPresent(id -> {
                WebSocket answerWebSocket = this.registry.byId((WebSocketId)id);
                metaData.set(WebsocketChainKeys.RECIPIENT_WEBSOCKETS, Collections.singletonList(answerWebSocket));
            });
        }
    }

    @Generated
    public String toString() {
        return "WebSocketInitializationProcessor(registry=" + this.registry + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebSocketInitializationProcessor)) {
            return false;
        }
        WebSocketInitializationProcessor other = (WebSocketInitializationProcessor)o;
        WebSocketRegistry this$registry = this.registry;
        WebSocketRegistry other$registry = other.registry;
        return !(this$registry == null ? other$registry != null : !((Object)this$registry).equals(other$registry));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebSocketRegistry $registry = this.registry;
        result = result * 59 + ($registry == null ? 43 : ((Object)$registry).hashCode());
        return result;
    }

    @Generated
    private WebSocketInitializationProcessor(WebSocketRegistry registry) {
        this.registry = registry;
    }
}

