/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets;

import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.MetricsProvider;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.chains.rules.Action;
import de.quantummaid.httpmaid.chains.rules.Consume;
import de.quantummaid.httpmaid.chains.rules.Jump;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebSocketMapping;
import de.quantummaid.httpmaid.websockets.WebSocketMetrics;
import de.quantummaid.httpmaid.websockets.WebsocketChainKeys;
import de.quantummaid.httpmaid.websockets.WebsocketChains;
import de.quantummaid.httpmaid.websockets.processors.ActivateWebSocketProcessor;
import de.quantummaid.httpmaid.websockets.processors.CreateWebSocketProcessor;
import de.quantummaid.httpmaid.websockets.processors.DetermineWebSocketTypeProcessor;
import de.quantummaid.httpmaid.websockets.processors.RemoveWebSocketFromRegistryProcessor;
import de.quantummaid.httpmaid.websockets.processors.WebSocketInitializationProcessor;
import de.quantummaid.httpmaid.websockets.registry.WebSocketRegistry;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public final class WebSocketModule
implements ChainModule {
    private final List<WebSocketMapping> webSocketMappings = new LinkedList<WebSocketMapping>();

    public static WebSocketModule webSocketModule() {
        return new WebSocketModule();
    }

    public void addWebSocketMapping(WebSocketMapping webSocketMapping) {
        Validators.validateNotNull((Object)webSocketMapping, (String)"webSocketMapping");
        this.webSocketMappings.add(webSocketMapping);
    }

    public void configure(DependencyRegistry dependencyRegistry) {
        MetricsProvider metricsProvider = dependencyRegistry.createMetricsProvider(WebSocketMetrics.NUMBER_OF_ACTIVE_WEB_SOCKETS, (Object)0);
        dependencyRegistry.setMetaDatum(WebsocketChainKeys.WEBSOCKET_REGISTRY, (Object)WebSocketRegistry.webSocketRegistry((MetricsProvider<Integer>)metricsProvider));
    }

    public void register(ChainExtender extender) {
        WebSocketRegistry registry = (WebSocketRegistry)extender.getMetaDatum(WebsocketChainKeys.WEBSOCKET_REGISTRY);
        WebSocketModule.createSkeleton(extender);
        extender.appendProcessor(HttpMaidChains.INIT, WebSocketInitializationProcessor.webSocketInitializationProcessor(registry));
        extender.appendProcessor(WebsocketChains.WEBSOCKET_ESTABLISHMENT, CreateWebSocketProcessor.createWebSocketProcessor(registry));
        extender.appendProcessor(WebsocketChains.DETERMINE_WEBSOCKET_TYPE, DetermineWebSocketTypeProcessor.determineWebSocketTypeProcessor(this.webSocketMappings));
        extender.appendProcessor(WebsocketChains.WEBSOCKET_OPEN, ActivateWebSocketProcessor.activateWebSocketProcessor(registry));
        extender.appendProcessor(WebsocketChains.WEBSOCKET_CLOSED, RemoveWebSocketFromRegistryProcessor.removeWebSocketFromRegistryProcessor(registry));
    }

    private static void createSkeleton(ChainExtender extender) {
        extender.createChain(WebsocketChains.WEBSOCKET_ESTABLISHMENT, Consume.consume(), (Action)Jump.jumpTo((ChainName)HttpMaidChains.EXCEPTION_OCCURRED));
        extender.createChain(WebsocketChains.DETERMINE_WEBSOCKET_TYPE, (Action)Jump.jumpTo((ChainName)WebsocketChains.WEBSOCKET_ESTABLISHMENT), (Action)Jump.jumpTo((ChainName)HttpMaidChains.EXCEPTION_OCCURRED));
        extender.routeIfSet(HttpMaidChains.PROCESS_HEADERS, (Action)Jump.jumpTo((ChainName)WebsocketChains.DETERMINE_WEBSOCKET_TYPE), WebsocketChainKeys.WEBSOCKET_ID);
        extender.createChain(WebsocketChains.WEBSOCKET_OPEN, Consume.consume(), (Action)Jump.jumpTo((ChainName)HttpMaidChains.EXCEPTION_OCCURRED));
        extender.createChain(WebsocketChains.WEBSOCKET_MESSAGE, (Action)Jump.jumpTo((ChainName)HttpMaidChains.PROCESS_BODY), (Action)Jump.jumpTo((ChainName)HttpMaidChains.EXCEPTION_OCCURRED));
        extender.createChain(WebsocketChains.SEND_TO_WEBSOCKETS, Consume.consume(), (Action)Jump.jumpTo((ChainName)HttpMaidChains.EXCEPTION_OCCURRED));
        extender.createChain(WebsocketChains.WEBSOCKET_CLOSED, Consume.consume(), (Action)Jump.jumpTo((ChainName)HttpMaidChains.EXCEPTION_OCCURRED));
        extender.createChain(WebsocketChains.WEBSOCKET_CLOSE, Consume.consume(), (Action)Jump.jumpTo((ChainName)HttpMaidChains.EXCEPTION_OCCURRED));
        extender.routeIfFlagIsSet(HttpMaidChains.INIT, (Action)Jump.jumpTo((ChainName)WebsocketChains.WEBSOCKET_MESSAGE), WebsocketChainKeys.IS_WEBSOCKET_MESSAGE);
        extender.routeIfFlagIsSet(HttpMaidChains.POST_PROCESS, (Action)Jump.jumpTo((ChainName)WebsocketChains.SEND_TO_WEBSOCKETS), WebsocketChainKeys.IS_WEBSOCKET_MESSAGE);
    }

    @Generated
    public String toString() {
        return "WebSocketModule(webSocketMappings=" + this.webSocketMappings + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebSocketModule)) {
            return false;
        }
        WebSocketModule other = (WebSocketModule)o;
        List<WebSocketMapping> this$webSocketMappings = this.webSocketMappings;
        List<WebSocketMapping> other$webSocketMappings = other.webSocketMappings;
        return !(this$webSocketMappings == null ? other$webSocketMappings != null : !((Object)this$webSocketMappings).equals(other$webSocketMappings));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<WebSocketMapping> $webSocketMappings = this.webSocketMappings;
        result = result * 59 + ($webSocketMappings == null ? 43 : ((Object)$webSocketMappings).hashCode());
        return result;
    }

    @Generated
    private WebSocketModule() {
    }
}

