/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.processors;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.http.PathParameters;
import de.quantummaid.httpmaid.path.Path;
import de.quantummaid.httpmaid.path.PathTemplate;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebSocketMapping;
import de.quantummaid.httpmaid.websockets.WebsocketChainKeys;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class DetermineWebSocketTypeProcessor
implements Processor {
    private final List<WebSocketMapping> webSocketMappings;

    public static Processor determineWebSocketTypeProcessor(List<WebSocketMapping> webSocketMappings) {
        Validators.validateNotNull(webSocketMappings, (String)"webSocketMappings");
        return new DetermineWebSocketTypeProcessor(webSocketMappings);
    }

    public void apply(MetaData metaData) {
        Path path = (Path)metaData.get(HttpMaidChainKeys.PATH);
        this.webSocketMappings.stream().filter(webSocketMapping -> webSocketMapping.pathTemplate().matches(path)).findFirst().ifPresent(webSocketMapping -> {
            metaData.set(WebsocketChainKeys.WEBSOCKET_MAPPING, webSocketMapping);
            PathTemplate pathTemplate = webSocketMapping.pathTemplate();
            Map pathParametersMap = pathTemplate.extractPathParameters(path);
            PathParameters pathParameters = PathParameters.pathParameters((Map)pathParametersMap);
            metaData.set(HttpMaidChainKeys.PATH_PARAMETERS, (Object)pathParameters);
        });
    }

    @Generated
    public String toString() {
        return "DetermineWebSocketTypeProcessor(webSocketMappings=" + this.webSocketMappings + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetermineWebSocketTypeProcessor)) {
            return false;
        }
        DetermineWebSocketTypeProcessor other = (DetermineWebSocketTypeProcessor)o;
        List<WebSocketMapping> this$webSocketMappings = this.webSocketMappings;
        List<WebSocketMapping> other$webSocketMappings = other.webSocketMappings;
        return !(this$webSocketMappings == null ? other$webSocketMappings != null : !((Object)this$webSocketMappings).equals(other$webSocketMappings));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<WebSocketMapping> $webSocketMappings = this.webSocketMappings;
        result = result * 59 + ($webSocketMappings == null ? 43 : ((Object)$webSocketMappings).hashCode());
        return result;
    }

    @Generated
    private DetermineWebSocketTypeProcessor(List<WebSocketMapping> webSocketMappings) {
        this.webSocketMappings = webSocketMappings;
    }
}

