/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.registry;

import de.quantummaid.httpmaid.util.Validators;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;

final class SaveMap<K, V> {
    private final Map<K, V> map;

    static <K, V> SaveMap<K, V> saveMap() {
        return new SaveMap(new HashMap());
    }

    void put(K key, V value) {
        Validators.validateNotNull(key, (String)"key");
        Validators.validateNotNull(value, (String)"value");
        this.map.put(key, value);
    }

    Optional<V> get(K key) {
        Validators.validateNotNull(key, (String)"key");
        return Optional.ofNullable(this.map.get(key));
    }

    Optional<V> getAndRemove(K key) {
        Validators.validateNotNull(key, (String)"key");
        Optional<V> value = Optional.ofNullable(this.map.get(key));
        value.ifPresent(x -> this.map.remove(key));
        return value;
    }

    void remove(K key, Supplier<RuntimeException> exceptionSupplier) {
        if (!this.map.containsKey(key)) {
            throw exceptionSupplier.get();
        }
        this.map.remove(key);
    }

    Set<V> copyOfValues() {
        return new HashSet<V>(this.map.values());
    }

    int size() {
        return this.map.size();
    }

    @Generated
    public String toString() {
        return "SaveMap(map=" + this.map + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaveMap)) {
            return false;
        }
        SaveMap other = (SaveMap)o;
        Map<K, V> this$map = this.map;
        Map<K, V> other$map = other.map;
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<K, V> $map = this.map;
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }

    @Generated
    private SaveMap(Map<K, V> map) {
        this.map = map;
    }
}

